/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.mortbay.io.bio.StreamEndPoint;

public class SocketEndPoint
extends StreamEndPoint {
    Socket _socket;
    InetSocketAddress _local;
    InetSocketAddress _remote;

    public SocketEndPoint(Socket socket) throws IOException {
        super(socket.getInputStream(), socket.getOutputStream());
        this._socket = socket;
    }

    public boolean isClosed() {
        return this._socket == null || this._socket.isClosed() || this._socket.isInputShutdown() || this._socket.isOutputShutdown();
    }

    public void close() throws IOException {
        this._socket.close();
        this._in = null;
        this._out = null;
    }

    public String getLocalAddr() {
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getHostAddress();
    }

    public String getLocalHost() {
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getCanonicalHostName();
    }

    public int getLocalPort() {
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        return this._local.getPort();
    }

    public String getRemoteAddr() {
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        return this._remote.getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        return this._remote.getAddress().getCanonicalHostName();
    }

    public int getRemotePort() {
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        return this._remote.getPort();
    }

    public Object getConnection() {
        return this._socket;
    }
}

