/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.error;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;

public class SnacError
extends SnacCommand {
    public static final int CODE_INVALID_SNAC = 1;
    public static final int CODE_TOO_FAST_TO_HOST = 2;
    public static final int CODE_TOO_FAST_TO_CLIENT = 3;
    public static final int CODE_USER_UNAVAILABLE = 4;
    public static final int CODE_SERVICE_UNAVAILABLE = 5;
    public static final int CODE_SERVICE_UNDEFINED = 6;
    public static final int CODE_OBSOLETE_SNAC = 7;
    public static final int CODE_NOT_SUPPORTED_BY_HOST = 8;
    public static final int CODE_NOT_SUPPORTED_BY_CLIENT = 9;
    public static final int CODE_REFUSED_BY_CLIENT = 10;
    public static final int CODE_REPLY_TOO_LARGE = 11;
    public static final int CODE_RESPONSES_LOST = 12;
    public static final int CODE_REQUEST_DENIED = 13;
    public static final int CODE_BROKEN_SNAC_DATA = 14;
    public static final int CODE_INSUFFICIENT_RIGHTS = 15;
    public static final int CODE_IN_LOCAL_PERMIT_DENY = 16;
    public static final int CODE_SENDER_WARNING_LEVEL = 17;
    public static final int CODE_RECEIVER_WARNING_LEVEL = 18;
    public static final int CODE_USER_TEMP_UNAVAILABLE = 19;
    public static final int CODE_NO_MATCH = 20;
    public static final int CODE_LIST_OVERFLOW = 21;
    public static final int CODE_REQUEST_AMBIGUOUS = 22;
    public static final int CODE_QUEUE_FULL = 23;
    public static final int CODE_NO_AOL = 24;
    public static final int CMD_ERROR = 1;
    private final int code;

    protected SnacError(SnacPacket packet) {
        super(packet.getFamily(), 1);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.code = BinaryTools.getUShort((ByteBlock)snacData, (int)0);
    }

    public SnacError(int family, int errorCode) {
        super(family, 1);
        DefensiveTools.checkRange((int)errorCode, (String)"errorCode", (int)0);
        this.code = errorCode;
    }

    public final int getErrorCode() {
        return this.code;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.code);
    }

    public String toString() {
        String name = null;
        name = MiscTools.findIntField(SnacError.class, this.code, "CODE_.*");
        return "SnacError: code=0x" + Integer.toHexString(this.code) + " (name: " + name + ")";
    }
}

