/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.Database;
import org.hsqldb.Trace;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.persist.ScaledRAInterface;

class ScaledRAFileNIO
implements ScaledRAInterface {
    private final boolean readOnly;
    private final long bufferLength;
    private RandomAccessFile file;
    private MappedByteBuffer buffer;
    private FileChannel channel;
    private boolean bufferModified;
    private SimpleLog appLog;

    ScaledRAFileNIO(Database database, String string, boolean bl, int n) throws Throwable {
        long l;
        if (n < 0x100000) {
            n = 0x100000;
        }
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        try {
            l = this.file.length();
        }
        catch (Throwable throwable) {
            this.file.close();
            throw throwable;
        }
        if (l > 0x10000000L) {
            this.file.close();
            throw new IOException("length exceeds nio limit");
        }
        if ((long)n < l) {
            n = (int)l;
        }
        n = ScaledRAFileNIO.newNIOBufferSize(n);
        if (bl) {
            n = (int)l;
        }
        if (l < (long)n) {
            try {
                this.file.seek(n - 1);
                this.file.writeByte(0);
                this.file.getFD().sync();
                this.file.close();
                this.file = new RandomAccessFile(string, bl ? "r" : "rw");
            }
            catch (Throwable throwable) {
                this.file.close();
                throw throwable;
            }
        }
        this.appLog = database.logger.appLog;
        this.readOnly = bl;
        this.bufferLength = n;
        this.channel = this.file.getChannel();
        try {
            this.buffer = this.channel.map(this.isReadOnly() ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, n);
            Trace.printSystemOut("NIO file instance created. mode: " + bl);
        }
        catch (Throwable throwable) {
            Trace.printSystemOut("NIO constructor failed:  " + n);
            this.buffer = null;
            this.channel = null;
            this.file.close();
            System.gc();
            throw throwable;
        }
    }

    public long length() throws IOException {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            this.appLog.logContext(iOException);
            throw iOException;
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public void seek(long l) throws IOException {
        try {
            this.buffer.position((int)l);
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public long getFilePointer() throws IOException {
        try {
            return this.buffer.position();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public int read() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.buffer.get(byArray, n, n2);
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.put(byArray, n, n2);
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public void writeInt(int n) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putInt(n);
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public void writeLong(long l) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putLong(l);
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public void close() throws IOException {
        try {
            Trace.printSystemOut("NIO close() start - fileLength = " + this.bufferLength);
            if (this.buffer != null && this.bufferModified) {
                this.buffer.force();
            }
            this.buffer = null;
            this.channel = null;
            this.file.close();
            Trace.printSystemOut("NIO close() end - fileLength = " + this.bufferLength);
            System.gc();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable);
            throw new IOException(throwable.toString());
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return true;
    }

    public boolean canAccess(int n) {
        return (long)(this.buffer.position() + n) <= this.bufferLength;
    }

    public boolean canSeek(long l) {
        return l <= this.bufferLength;
    }

    public Database getDatabase() {
        return null;
    }

    static int newNIOBufferSize(int n) {
        int n2 = 0;
        for (int i = 20; i < 30 && (n2 = 1 << i) < n; ++i) {
        }
        return n2;
    }
}

