/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.concurrent.lock.client.AbstractIsLockedRequest;
import com.hazelcast.multimap.MultiMapPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;
import java.security.Permission;

public class MultiMapIsLockedRequest
extends AbstractIsLockedRequest
implements RetryableRequest {
    String name;

    public MultiMapIsLockedRequest() {
    }

    public MultiMapIsLockedRequest(Data key, String name) {
        super(key);
        this.name = name;
    }

    @Override
    protected ObjectNamespace getNamespace() {
        return new DefaultObjectNamespace("hz:impl:multiMapService", this.name);
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        super.readPortable(reader);
    }

    @Override
    public int getFactoryId() {
        return MultiMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 18;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "lock");
    }
}

