/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.list;

import com.hazelcast.collection.AbstractCollectionProxyImpl;
import com.hazelcast.collection.list.ListAddAllOperation;
import com.hazelcast.collection.list.ListAddOperation;
import com.hazelcast.collection.list.ListGetOperation;
import com.hazelcast.collection.list.ListIndexOfOperation;
import com.hazelcast.collection.list.ListRemoveOperation;
import com.hazelcast.collection.list.ListService;
import com.hazelcast.collection.list.ListSetOperation;
import com.hazelcast.collection.list.ListSubOperation;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.core.IList;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.SerializableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ListProxyImpl<E>
extends AbstractCollectionProxyImpl<ListService, E>
implements IList<E> {
    protected ListProxyImpl(String name, NodeEngine nodeEngine, ListService service) {
        super(name, nodeEngine, service);
    }

    @Override
    protected CollectionConfig getConfig(NodeEngine nodeEngine) {
        return nodeEngine.getConfig().findListConfig(this.name);
    }

    @Override
    public void add(int index, E e) {
        this.throwExceptionIfNull(e);
        Data value = this.getNodeEngine().toData(e);
        ListAddOperation operation = new ListAddOperation(this.name, index, value);
        this.invoke(operation);
    }

    @Override
    public E get(int index) {
        ListGetOperation operation = new ListGetOperation(this.name, index);
        return (E)this.invoke(operation);
    }

    @Override
    public E set(int index, E element) {
        this.throwExceptionIfNull(element);
        Data value = this.getNodeEngine().toData(element);
        ListSetOperation operation = new ListSetOperation(this.name, index, value);
        return (E)this.invoke(operation);
    }

    @Override
    public E remove(int index) {
        ListRemoveOperation operation = new ListRemoveOperation(this.name, index);
        return (E)this.invoke(operation);
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOfInternal(false, o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOfInternal(true, o);
    }

    private int indexOfInternal(boolean last, Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.getNodeEngine().toData(o);
        ListIndexOfOperation operation = new ListIndexOfOperation(this.name, last, value);
        Integer result = (Integer)this.invoke(operation);
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        NodeEngine nodeEngine = this.getNodeEngine();
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(nodeEngine.toData(e));
        }
        ListAddAllOperation operation = new ListAddAllOperation(this.name, index, valueList);
        Boolean result = (Boolean)this.invoke(operation);
        return result;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        List<E> list = this.subList(-1, -1);
        return list.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ListSubOperation operation = new ListSubOperation(this.name, fromIndex, toIndex);
        SerializableCollection result = (SerializableCollection)this.invoke(operation);
        Collection<Data> collection = result.getCollection();
        ArrayList list = new ArrayList(collection.size());
        NodeEngine nodeEngine = this.getNodeEngine();
        for (Data data : collection) {
            list.add(nodeEngine.toObject(data));
        }
        return list;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public Object[] toArray() {
        return this.subList(-1, -1).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.throwExceptionIfNull(a);
        return this.subList(-1, -1).toArray(a);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:listService";
    }
}

