/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTPSourceInfoCache;
import net.sf.fmj.media.rtp.SSRCInfo;

public abstract class RTPSourceInfo
implements Participant {
    RTPSourceInfoCache sic;
    private SSRCInfo[] ssrc;
    private SourceDescription cname;

    RTPSourceInfo(String string, RTPSourceInfoCache rTPSourceInfoCache) {
        this.cname = new SourceDescription(1, string, 0, false);
        this.sic = rTPSourceInfoCache;
        this.ssrc = new SSRCInfo[0];
    }

    synchronized void addSSRC(SSRCInfo sSRCInfo) {
        for (int i = 0; i < this.ssrc.length; ++i) {
            if (this.ssrc[i] != sSRCInfo) continue;
            return;
        }
        this.ssrc = new SSRCInfo[this.ssrc.length + 1];
        System.arraycopy(this.ssrc, 0, this.ssrc, 0, this.ssrc.length - 1);
        this.ssrc[this.ssrc.length - 1] = sSRCInfo;
    }

    public String getCNAME() {
        return this.cname.getDescription();
    }

    SourceDescription getCNAMESDES() {
        return this.cname;
    }

    public Vector getReports() {
        Vector<SSRCInfo> vector = new Vector<SSRCInfo>();
        for (int i = 0; i < this.ssrc.length; ++i) {
            vector.addElement(this.ssrc[i]);
        }
        vector.trimToSize();
        return vector;
    }

    public Vector getSourceDescription() {
        Vector<Object> vector = null;
        if (this.ssrc.length == 0) {
            vector = new Vector(0);
            return vector;
        }
        vector = this.ssrc[0].getSourceDescription();
        return vector;
    }

    RTPStream getSSRCStream(long l) {
        for (int i = 0; i < this.ssrc.length; ++i) {
            if (!(this.ssrc[i] instanceof RTPStream) || this.ssrc[i].ssrc != (int)l) continue;
            return (RTPStream)((Object)this.ssrc[i]);
        }
        return null;
    }

    int getStreamCount() {
        return this.ssrc.length;
    }

    public Vector getStreams() {
        Vector<SSRCInfo> vector = new Vector<SSRCInfo>();
        for (int i = 0; i < this.ssrc.length; ++i) {
            if (!this.ssrc[i].isActive()) continue;
            vector.addElement(this.ssrc[i]);
        }
        vector.trimToSize();
        return vector;
    }

    synchronized void removeSSRC(SSRCInfo sSRCInfo) {
        if (sSRCInfo.dsource != null) {
            this.sic.ssrccache.sm.removeDataSource(sSRCInfo.dsource);
        }
        for (int i = 0; i < this.ssrc.length; ++i) {
            if (this.ssrc[i] != sSRCInfo) continue;
            this.ssrc[i] = this.ssrc[this.ssrc.length - 1];
            this.ssrc = new SSRCInfo[this.ssrc.length - 1];
            System.arraycopy(this.ssrc, 0, this.ssrc, 0, this.ssrc.length);
            break;
        }
        if (this.ssrc.length == 0) {
            this.sic.remove(this.cname.getDescription());
        }
    }
}

