/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls.skins.ejmf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public abstract class BasicControlButton
extends JButton
implements SwingConstants {
    public BasicControlButton() {
        this.setBackground(UIManager.getColor("control"));
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getPreferredSize() {
        return new Dimension(20, 20);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = graphics.getColor();
        boolean bl = this.getModel().isPressed();
        boolean bl2 = this.isEnabled();
        graphics.setColor(this.getBackground());
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        if (bl) {
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        } else {
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawLine(1, 1, 1, n2 - 3);
            graphics.drawLine(2, 1, n - 3, 1);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, n - 1, 0);
        }
        if (n2 < 5 || n < 5) {
            graphics.setColor(color);
            return;
        }
        if (bl) {
            graphics.translate(1, 1);
        }
        int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
        n3 = Math.max(n3, 2);
        this.paintIcon(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, bl2);
        if (bl) {
            graphics.translate(-1, -1);
        }
        graphics.setColor(color);
    }

    protected abstract void paintIcon(Graphics var1, int var2, int var3, int var4, boolean var5);
}

