/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rtcp;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESItem;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCInfo;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.ReceiverFeedbackFilter;
import org.jitsi.impl.neomedia.rtp.translator.Payload;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.Transformer;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.rtp.RemoteBitrateEstimator;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.rtcp.AbstractBridgeRTCPTerminationStrategy;
import org.jitsi.videobridge.rtcp.REMBNotifier;
import org.jitsi.videobridge.rtcp.RTCPPacketPayload;
import org.jitsi.videobridge.rtcp.SenderFeedbackExploder;

public class BasicBridgeRTCPTerminationStrategy
extends AbstractBridgeRTCPTerminationStrategy {
    private static final Logger logger = Logger.getLogger(BasicBridgeRTCPTerminationStrategy.class);

    public BasicBridgeRTCPTerminationStrategy() {
        this.setTransformerChain(new Transformer[]{new REMBNotifier(this), new ReceiverFeedbackFilter(), new SenderFeedbackExploder(this)});
    }

    public RTCPPacket[] makeReports() {
        RTPTranslator rtpTranslator = this.getRTPTranslator();
        if (!(rtpTranslator instanceof RTPTranslatorImpl)) {
            return null;
        }
        Conference conference = this.getConference();
        if (conference == null) {
            return null;
        }
        long time = System.currentTimeMillis();
        RTPTranslatorImpl rtpTranslatorImpl = (RTPTranslatorImpl)rtpTranslator;
        int localSSRC = (int)rtpTranslatorImpl.getLocalSSRC(null);
        RTCPTransmitter rtcpTransmitter = this.getRTCPReportBuilder().getRTCPTransmitter();
        for (Endpoint endpoint : conference.getEndpoints()) {
            for (RtpChannel channel : endpoint.getChannels(MediaType.VIDEO)) {
                RTCPPacket[] packets = this.makeReportsForChannel((VideoChannel)channel, time, localSSRC);
                if (packets == null || packets.length == 0) continue;
                RTCPCompoundPacket compoundPacket = new RTCPCompoundPacket(packets);
                RTCPPacketPayload payload = new RTCPPacketPayload(compoundPacket);
                rtpTranslatorImpl.writeControlPayload((Payload)payload, channel.getStream());
                rtcpTransmitter.onRTCPCompoundPacketSent(compoundPacket);
            }
        }
        return null;
    }

    private RTCPSDES createRTCPSDES(int ssrc) {
        String cname;
        RTCPTransmitter rtcpTransmitter = this.getRTCPReportBuilder().getRTCPTransmitter();
        SSRCInfo ssrcInfo = (SSRCInfo)rtcpTransmitter.cache.cache.get(ssrc);
        RTCPSDES rtcpSDES = null;
        if (ssrcInfo != null && (cname = ssrcInfo.getCNAME()) != null) {
            rtcpSDES = new RTCPSDES();
            rtcpSDES.ssrc = ssrc;
            rtcpSDES.items = new RTCPSDESItem[]{new RTCPSDESItem(1, cname)};
        }
        return rtcpSDES;
    }

    private RTCPReportBlock[] createRTCPReportBlocksForChannel(VideoChannel videoChannel, long time) {
        RTCPTransmitter rtcpTransmitter = this.getRTCPReportBuilder().getRTCPTransmitter();
        int[] ssrcs = videoChannel.getReceiveSSRCs();
        ArrayList<RTCPReportBlock> receiverReports = new ArrayList<RTCPReportBlock>(ssrcs.length);
        for (int ssrc : ssrcs) {
            SSRCInfo info = (SSRCInfo)rtcpTransmitter.cache.cache.get(ssrc);
            if (info != null) {
                RTCPReportBlock receiverReport = info.makeReceiverReport(time);
                receiverReports.add(receiverReport);
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("FMJ has no information for SSRC " + ((long)ssrc & 0xFFFFFFFFL) + " (" + ssrc + ")"));
        }
        return receiverReports.toArray(new RTCPReportBlock[receiverReports.size()]);
    }

    private RTCPREMBPacket createRTCPREMBPacketForChannel(VideoChannel videoChannel, int localSSRC) {
        if (videoChannel == null) {
            throw new IllegalArgumentException("videoChannel");
        }
        RemoteBitrateEstimator remoteBitrateEstimator = ((VideoMediaStream)videoChannel.getStream()).getRemoteBitrateEstimator();
        Collection ssrcs = remoteBitrateEstimator.getSsrcs();
        long[] dest = new long[ssrcs.size()];
        int i = 0;
        for (Integer ssrc : ssrcs) {
            dest[i++] = (long)ssrc.intValue() & 0xFFFFFFFFL;
        }
        long bitrate = remoteBitrateEstimator.getLatestEstimate();
        if (bitrate == -1L) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Estimated bitrate: " + bitrate));
        }
        return new RTCPREMBPacket((long)localSSRC & 0xFFFFFFFFL, 0L, bitrate, dest);
    }

    private RTCPPacket[] makeReportsForChannel(VideoChannel videoChannel, long time, int localSSRC) {
        ArrayList<Object> packets = new ArrayList<Object>(3);
        RTCPReportBlock[] receiverReports = this.createRTCPReportBlocksForChannel(videoChannel, time);
        RTCPRRPacket rr = new RTCPRRPacket(localSSRC, receiverReports);
        packets.add(rr);
        RTCPREMBPacket remb = this.createRTCPREMBPacketForChannel(videoChannel, localSSRC);
        if (remb != null) {
            packets.add(remb);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)remb);
            }
        }
        ArrayList<RTCPSDES> sdesChunks = new ArrayList<RTCPSDES>(1 + receiverReports.length);
        RTCPSDES sdesChunk = this.createRTCPSDES(localSSRC);
        if (sdesChunk != null) {
            sdesChunks.add(sdesChunk);
        }
        long[] dest = new long[receiverReports.length];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = receiverReports[i].getSSRC();
        }
        for (long ssrc : dest) {
            sdesChunk = this.createRTCPSDES((int)ssrc);
            if (sdesChunk == null) continue;
            sdesChunks.add(sdesChunk);
        }
        if (sdesChunks.size() != 0) {
            RTCPSDESPacket sdes = new RTCPSDESPacket(sdesChunks.toArray(new RTCPSDES[sdesChunks.size()]));
            packets.add(sdes);
        }
        return packets.toArray(new RTCPPacket[packets.size()]);
    }
}

