/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui;

import com.lti.utils.OSUtils;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JFrame;
import net.sf.fmj.ui.application.PlayerPanel;
import net.sf.fmj.ui.dialogs.AboutPanel;
import net.sf.fmj.ui.registry.RegistryEditorPanel;
import net.sf.fmj.utility.FmjStartup;

public class FmjStudio {
    private JFrame frame;
    private JFrame registryFrame;
    private PlayerPanel playerPanel;

    public static void main(String[] stringArray) {
        FmjStartup.init();
        if (OSUtils.isMacOSX()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "FMJ Studio");
        }
        FmjStudio fmjStudio = new FmjStudio();
        fmjStudio.run(stringArray);
    }

    private final MenuBar getMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu();
        menu.setLabel("File");
        menuBar.add(menu);
        MenuItem menuItem = new MenuItem("Open File...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmjStudio.this.playerPanel.onOpenFile();
            }
        });
        menu.add(menuItem);
        menuItem = new MenuItem("Open URL...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmjStudio.this.playerPanel.onOpenURL();
            }
        });
        menu.add(menuItem);
        menuItem = new MenuItem("Open RTP Session...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmjStudio.this.playerPanel.onReceiveRTP();
            }
        });
        menu.add(menuItem);
        menuItem = new MenuItem("Capture...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmjStudio.this.playerPanel.onOpenCaptureDevice();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new MenuItem("Transmit RTP...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmjStudio.this.playerPanel.onTransmitRTP();
            }
        });
        menu.add(menuItem);
        menuItem = new MenuItem("Transcode...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmjStudio.this.playerPanel.onTranscode();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new MenuItem("Registry Editor...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmjStudio.this.onOpenRegistryEditor();
            }
        });
        menu.add(menuItem);
        menuItem = new MenuItem("Exit");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmjStudio.this.onExit();
            }
        });
        menu.add(menuItem);
        menuItem = new Menu();
        menuItem.setLabel("Player");
        menuBar.add((Menu)menuItem);
        MenuItem menuItem2 = new CheckboxMenuItem("Auto-play");
        ((CheckboxMenuItem)menuItem2).addItemListener(new ItemListener((CheckboxMenuItem)menuItem2){
            final /* synthetic */ CheckboxMenuItem val$menuItemAutoPlay;
            {
                this.val$menuItemAutoPlay = checkboxMenuItem;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                FmjStudio.this.playerPanel.onAutoPlay(this.val$menuItemAutoPlay.getState());
            }
        });
        ((Menu)menuItem).add(menuItem2);
        ((CheckboxMenuItem)menuItem2).setState(this.playerPanel.getPrefs().autoPlay);
        menuItem2 = new CheckboxMenuItem("Auto-loop");
        ((CheckboxMenuItem)menuItem2).addItemListener(new ItemListener((CheckboxMenuItem)menuItem2){
            final /* synthetic */ CheckboxMenuItem val$menuItemAutoLoop;
            {
                this.val$menuItemAutoLoop = checkboxMenuItem;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                FmjStudio.this.playerPanel.onAutoLoop(this.val$menuItemAutoLoop.getState());
            }
        });
        ((Menu)menuItem).add(menuItem2);
        this.playerPanel.onAutoLoop(false);
        ((CheckboxMenuItem)menuItem2).setState(this.playerPanel.getPrefs().autoLoop);
        menuItem2.setEnabled(false);
        menuItem2 = new Menu();
        menuItem2.setLabel("Help");
        menuBar.add((Menu)menuItem2);
        MenuItem menuItem3 = new MenuItem("About...");
        menuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutPanel.run(FmjStudio.this.frame);
            }
        });
        ((Menu)menuItem2).add(menuItem3);
        return menuBar;
    }

    private void onExit() {
        if (this.registryFrame != null) {
            this.registryFrame.dispose();
        }
        this.frame.dispose();
    }

    private void onOpenRegistryEditor() {
        if (this.registryFrame == null) {
            this.registryFrame = new JFrame("Registry Editor");
            RegistryEditorPanel registryEditorPanel = new RegistryEditorPanel();
            Container container = this.registryFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)registryEditorPanel, "Center");
            this.registryFrame.setSize(640, 480);
        }
        this.registryFrame.setVisible(true);
    }

    private void run(String[] stringArray) {
        this.frame = new JFrame("FMJ Studio");
        this.frame.setSize(new Dimension(640, 480));
        this.frame.setDefaultCloseOperation(3);
        Container container = this.frame.getContentPane();
        this.playerPanel = new PlayerPanel();
        container.add(this.playerPanel);
        this.frame.setMenuBar(this.getMenuBar());
        this.playerPanel.getVideoPanel().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                FmjStudio.this.frame.pack();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                FmjStudio.this.frame.pack();
            }
        });
        this.frame.setVisible(true);
        if (stringArray.length > 0) {
            String string = stringArray[0];
            this.playerPanel.addMediaLocatorAndLoad(string);
        }
    }
}

