/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ffmpeg_java;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import net.sf.ffmpeg_java.AVCodecLibrary;
import net.sf.ffmpeg_java.AVFormatLibrary;
import net.sf.ffmpeg_java.AVUtilLibrary;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListFormats {
    private static final Logger logger = LoggerSingleton.logger;
    static final int CODEC_TYPE_UNKNOWN = -1;
    static final int CODEC_TYPE_VIDEO = 0;
    static final int CODEC_TYPE_AUDIO = 1;
    static final int CODEC_TYPE_DATA = 2;
    static final int CODEC_TYPE_SUBTITLE = 3;
    static final int CODEC_TYPE_NB = 4;
    static final AVFormatLibrary AVFORMAT = AVFormatLibrary.INSTANCE;
    static final AVCodecLibrary AVCODEC = AVCodecLibrary.INSTANCE;
    static final AVUtilLibrary AVUTIL = AVUtilLibrary.INSTANCE;
    static final String FIRST_FFMPEG_MUX_NAME = "ac3";
    static final String FIRST_FFMPEG_DECODER_NAME = "aasc";
    static final String FIRST_FFMPEG_ENCODER_NAME = "asv1";
    static final int JPEG_QUALITY = 100;

    public static AudioFormat convertCodecAudioFormat(AVCodecLibrary.AVCodecContext aVCodecContext) {
        return new AudioFormat("LINEAR", aVCodecContext.sample_rate, 16, aVCodecContext.channels);
    }

    public static VideoFormat convertCodecPixelFormat(int n, int n2, int n3, float f) {
        RGBFormat rGBFormat = null;
        int n4 = ListFormats.getCpuEndianess();
        switch (n) {
            case 2: {
                int n5 = 1;
                int n6 = 2;
                int n7 = 3;
                int n8 = 24;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.byteArray, f, n8, n5, n6, n7);
                break;
            }
            case 3: {
                int n9 = 3;
                int n10 = 2;
                int n11 = 1;
                int n12 = 24;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.byteArray, f, n12, n9, n10, n11);
                break;
            }
            case 6: {
                int n13 = 0xFF0000;
                int n14 = 65280;
                int n15 = 255;
                int n16 = 32;
                int n17 = 1;
                int n18 = n2 * n17;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.intArray, f, n16, n13, n14, n15, n17, n18, 0, n4);
                break;
            }
            case 9: {
                int n19 = 31;
                int n20 = 2016;
                int n21 = 63488;
                int n22 = 16;
                int n23 = 1;
                int n24 = n2 * n23;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.shortArray, f, n22, n19, n20, n21, n23, n24, 0, n4);
                break;
            }
            case 10: {
                int n25 = 31;
                int n26 = 992;
                int n27 = 31744;
                int n28 = 16;
                int n29 = 1;
                int n30 = n2 * n29;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.shortArray, f, n28, n25, n26, n27, n29, n30, 0, n4);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 22: {
                int n31 = 255;
                int n32 = 65280;
                int n33 = 0xFF0000;
                int n34 = 32;
                int n35 = 1;
                int n36 = n2 * n35;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.intArray, f, n34, n31, n32, n33, n35, n36, 0, n4);
                break;
            }
            case 23: {
                int n37 = 63488;
                int n38 = 2016;
                int n39 = 31;
                int n40 = 16;
                int n41 = 1;
                int n42 = n2 * n41;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.shortArray, f, n40, n37, n38, n39, n41, n42, 0, n4);
                break;
            }
            case 24: {
                int n43 = 31744;
                int n44 = 992;
                int n45 = 31;
                int n46 = 16;
                int n47 = 1;
                int n48 = n2 * n47;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.shortArray, f, n46, n43, n44, n45, n47, n48, 0, n4);
                break;
            }
            case 25: {
                int n49 = 224;
                int n50 = 28;
                int n51 = 3;
                int n52 = 8;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.byteArray, f, n52, n49, n50, n51);
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                int n53 = 8;
                int n54 = 6;
                int n55 = 1;
                int n56 = 8;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.byteArray, f, n56, n53, n54, n55);
                break;
            }
            case 28: {
                int n57 = 7;
                int n58 = 56;
                int n59 = 192;
                int n60 = 8;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.byteArray, f, n60, n57, n58, n59);
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                int n61 = 1;
                int n62 = 6;
                int n63 = 8;
                int n64 = 8;
                rGBFormat = new RGBFormat(new Dimension(n2, n3), -1, Format.byteArray, f, n64, n61, n62, n63);
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case -1: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
            case 1: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 40: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
        }
        return rGBFormat;
    }

    protected static String getCodecType(int n) {
        String string = null;
        switch (n) {
            case -1: {
                string = "unknown";
                break;
            }
            case 0: {
                string = "video";
                break;
            }
            case 1: {
                string = "audio";
                break;
            }
            case 2: {
                string = "data";
                break;
            }
            case 3: {
                string = "subtitle";
                break;
            }
            case 4: {
                string = "nb";
            }
        }
        return string;
    }

    public static final int getCpuEndianess() {
        return ListFormats.isBigEndian() ? 0 : 1;
    }

    public static int getPixelFormatFromBufferedImageType(int n) {
        int n2;
        switch (n) {
            case 2: {
                n2 = 6;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
            case 1: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 22;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 22;
                break;
            }
            case 7: {
                n2 = 22;
                break;
            }
            case 9: {
                n2 = 10;
                break;
            }
            case 8: {
                n2 = 9;
                break;
            }
            case 11: {
                if (ListFormats.isBigEndian()) {
                    n2 = 35;
                    break;
                }
                n2 = 36;
                break;
            }
            case 12: {
                n2 = 6;
                break;
            }
            case 10: {
                n2 = 11;
                break;
            }
            case 13: {
                n2 = 14;
                break;
            }
            default: {
                n2 = 6;
            }
        }
        return n2;
    }

    public static int getPreferedBufferedImageType() {
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsDevice graphicsDevice = graphicsDeviceArray[0];
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getConfigurations()[0];
        return graphicsConfiguration.createCompatibleImage(1, 1).getType();
    }

    public static int getPreferedPixelFormat() {
        return ListFormats.getPixelFormatFromBufferedImageType(ListFormats.getPreferedBufferedImageType());
    }

    public static ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] formatArray) {
        List<String> list = ListFormats.listMuxes();
        return list.toArray(new ContentDescriptor[0]);
    }

    public static final boolean isBigEndian() {
        return ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder());
    }

    static void listDecoder() {
        int n = 1;
        AVCodecLibrary.AVCodec aVCodec = AVCODEC.avcodec_find_decoder_by_name(FIRST_FFMPEG_DECODER_NAME);
        while (aVCodec != null) {
            logger.log(Level.FINEST, n++ + ". " + aVCodec.name + " (" + ListFormats.getCodecType(aVCodec.type) + ")");
            if (aVCodec.next != null) {
                aVCodec = new AVCodecLibrary.AVCodec(aVCodec.next);
                continue;
            }
            aVCodec = null;
        }
    }

    static void listEncoder() {
        int n = 1;
        AVCodecLibrary.AVCodec aVCodec = AVCODEC.avcodec_find_decoder_by_name(FIRST_FFMPEG_ENCODER_NAME);
        while (aVCodec != null) {
            logger.log(Level.FINEST, n++ + ". " + aVCodec.name + " (" + ListFormats.getCodecType(aVCodec.type) + ")");
            if (aVCodec.next != null) {
                aVCodec = new AVCodecLibrary.AVCodec(aVCodec.next);
                continue;
            }
            aVCodec = null;
        }
    }

    static List<String> listMuxes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        AVFormatLibrary.AVOutputFormat aVOutputFormat = AVFORMAT.guess_format(FIRST_FFMPEG_MUX_NAME, null, null);
        while (aVOutputFormat != null) {
            String string = aVOutputFormat.mime_type;
            if (string == null || string.length() <= 0) {
                string = "ffmpeg/" + aVOutputFormat.name;
            }
            logger.log(Level.FINEST, n++ + ". " + aVOutputFormat.name + " - " + aVOutputFormat.long_name + " : " + string);
            arrayList.add(ContentDescriptor.mimeTypeToPackageName(string));
            aVOutputFormat = aVOutputFormat.next != null ? new AVFormatLibrary.AVOutputFormat(aVOutputFormat.next) : null;
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        AVFORMAT.av_register_all();
        ListFormats.listMuxes();
        ListFormats.listDecoder();
        ListFormats.listEncoder();
    }
}

