/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rv;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rv.RvProcessor;
import net.kano.joscar.rv.RvSession;

public class NewRvSessionEvent {
    public static final EventType TYPE_INCOMING = new EventType("TYPE_INCOMING");
    public static final EventType TYPE_OUTGOING = new EventType("TYPE_OUTGOING");
    private final RvProcessor rvProcessor;
    private final RvSession newSession;
    private final EventType sessionType;

    protected NewRvSessionEvent(RvProcessor rvProcessor, RvSession newSession, EventType sessionType) {
        DefensiveTools.checkNull((Object)rvProcessor, (String)"rvProcessor");
        DefensiveTools.checkNull((Object)newSession, (String)"newSession");
        if (sessionType != TYPE_INCOMING && sessionType != TYPE_OUTGOING) {
            throw new IllegalArgumentException("sessionType (" + sessionType + ") must be either TYPE_INCOMING or " + "TYPE_OUTGOING");
        }
        this.rvProcessor = rvProcessor;
        this.newSession = newSession;
        this.sessionType = sessionType;
    }

    public final RvProcessor getRvProcessor() {
        return this.rvProcessor;
    }

    public final RvSession getSession() {
        return this.newSession;
    }

    public final EventType getSessionType() {
        return this.sessionType;
    }

    public String toString() {
        return "NewRvSessionEvent: rvProcessor=" + this.rvProcessor + ", newSession=" + this.newSession + ", sessionType=" + this.sessionType;
    }

    public static final class EventType {
        private final String name;

        private EventType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

