/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.impl.AbstractCacheProxyInternal;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.operation.CacheGetAllOperationFactory;
import com.hazelcast.cache.impl.operation.CacheGetOperation;
import com.hazelcast.cache.impl.operation.CacheSizeOperationFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractCacheProxyExtension<K, V>
extends AbstractCacheProxyInternal<K, V> {
    protected AbstractCacheProxyExtension(CacheConfig cacheConfig, NodeEngine nodeEngine, CacheService cacheService) {
        super(cacheConfig, nodeEngine, cacheService);
    }

    @Override
    public InternalCompletableFuture<V> getAsync(K key) {
        return this.getAsync((Object)key, (ExpiryPolicy)null);
    }

    @Override
    public InternalCompletableFuture<V> getAsync(K key, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Data keyData = this.serializationService.toData(key);
        CacheGetOperation op = new CacheGetOperation(this.getDistributedObjectName(), keyData, expiryPolicy);
        return this.invoke(op, keyData, false);
    }

    public InternalCompletableFuture<Void> putAsync(K key, V value) {
        return this.putAsync((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public InternalCompletableFuture<Void> putAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, false, false);
    }

    public InternalCompletableFuture<Boolean> putIfAbsentAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putIfAbsentAsyncInternal(key, value, expiryPolicy, false);
    }

    @Override
    public Future<V> getAndPutAsync(K key, V value) {
        return this.getAndPutAsync(key, value, null);
    }

    @Override
    public Future<V> getAndPutAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, true, false);
    }

    public InternalCompletableFuture<Boolean> removeAsync(K key) {
        return this.removeAsyncInternal(key, null, false, false, false);
    }

    public InternalCompletableFuture<Boolean> removeAsync(K key, V oldValue) {
        return this.removeAsyncInternal(key, oldValue, true, false, false);
    }

    @Override
    public Future<V> getAndRemoveAsync(K key) {
        return this.removeAsyncInternal(key, null, false, true, false);
    }

    @Override
    public Future<Boolean> replaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, false, false);
    }

    @Override
    public Future<Boolean> replaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, false);
    }

    @Override
    public Future<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsyncInternal(key, oldValue, newValue, null, true, false, false);
    }

    @Override
    public Future<Boolean> replaceAsync(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, false);
    }

    @Override
    public Future<V> getAndReplaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, true, false);
    }

    @Override
    public Future<V> getAndReplaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, true, false);
    }

    @Override
    public V get(K key, ExpiryPolicy expiryPolicy) {
        Future f = this.getAsync((Object)key, expiryPolicy);
        try {
            return f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (keys.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashSet<Data> ks = new HashSet<Data>(keys.size());
        for (K key : keys) {
            Data k = this.serializationService.toData(key);
            ks.add(k);
        }
        HashMap result = new HashMap();
        Set<Integer> partitions = this.getPartitionsForKeys(ks);
        try {
            CacheGetAllOperationFactory factory = new CacheGetAllOperationFactory(this.getDistributedObjectName(), ks, expiryPolicy);
            Map<Integer, Object> responses = this.getNodeEngine().getOperationService().invokeOnPartitions(this.getServiceName(), factory, partitions);
            for (Object response : responses.values()) {
                Object responseObject = this.serializationService.toObject(response);
                Set<Map.Entry<Data, Data>> entries = ((MapEntrySet)responseObject).getEntrySet();
                for (Map.Entry<Data, Data> entry : entries) {
                    Object value = this.serializationService.toObject(entry.getValue());
                    Object key = this.serializationService.toObject(entry.getKey());
                    result.put(key, value);
                }
            }
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
        return result;
    }

    @Override
    public void put(K key, V value, ExpiryPolicy expiryPolicy) {
        InternalCompletableFuture f = this.putAsyncInternal(key, value, expiryPolicy, false, true);
        try {
            f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public V getAndPut(K key, V value, ExpiryPolicy expiryPolicy) {
        InternalCompletableFuture f = this.putAsyncInternal(key, value, expiryPolicy, true, true);
        try {
            return f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(map);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), expiryPolicy);
        }
    }

    @Override
    public boolean putIfAbsent(K key, V value, ExpiryPolicy expiryPolicy) {
        InternalCompletableFuture<Boolean> f = this.putIfAbsentAsyncInternal(key, value, expiryPolicy, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        InternalCompletableFuture f = this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public boolean replace(K key, V value, ExpiryPolicy expiryPolicy) {
        InternalCompletableFuture f = this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public V getAndReplace(K key, V value, ExpiryPolicy expiryPolicy) {
        InternalCompletableFuture f = this.replaceAsyncInternal(key, null, value, expiryPolicy, false, true, true);
        try {
            return f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public int size() {
        this.ensureOpen();
        try {
            SerializationService serializationService = this.getNodeEngine().getSerializationService();
            CacheSizeOperationFactory operationFactory = new CacheSizeOperationFactory(this.getDistributedObjectName());
            Map<Integer, Object> results = this.getNodeEngine().getOperationService().invokeOnAllPartitions(this.getServiceName(), operationFactory);
            int total = 0;
            for (Object result : results.values()) {
                Integer size = result instanceof Data ? (Integer)serializationService.toObject((Data)result) : (Integer)result;
                total += size.intValue();
            }
            return total;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    @Override
    public CacheStatistics getLocalCacheStatistics() {
        CacheService service = this.getService();
        CacheStatisticsImpl statistics = service.createCacheStatIfAbsent(this.name);
        return statistics;
    }

    private Set<Integer> getPartitionsForKeys(Set<Data> keys) {
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        int partitions = partitionService.getPartitionCount();
        int capacity = Math.min(partitions, keys.size());
        HashSet<Integer> partitionIds = new HashSet<Integer>(capacity);
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext() && partitionIds.size() < partitions) {
            Data key = iterator.next();
            partitionIds.add(partitionService.getPartitionId(key));
        }
        return partitionIds;
    }
}

