/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import net.kano.joscar.rvproto.ft.FileTransferChecksum;

public class FileTransferTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getChecksum(FileChannel fileChannel, long offset, long length) throws IOException {
        long oldPos = fileChannel.position();
        try {
            long l = FileTransferTools.getChecksumRuinPosition(fileChannel, offset, length);
            return l;
        }
        finally {
            fileChannel.position(oldPos);
        }
    }

    static long getChecksumRuinPosition(FileChannel fileChannel, long offset, long length) throws IOException {
        long remaining;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        fileChannel.position(offset);
        FileTransferChecksum summer = new FileTransferChecksum();
        for (remaining = length; remaining > 0L; remaining -= (long)buffer.limit()) {
            buffer.rewind();
            buffer.limit((int)Math.min(remaining, (long)buffer.capacity()));
            int count = fileChannel.read(buffer);
            if (count == -1) break;
            buffer.flip();
            summer.update(buffer.array(), buffer.arrayOffset(), buffer.limit());
        }
        if (remaining > 0L) {
            throw new IOException("could not get checksum for entire file; " + remaining + " failed of " + length);
        }
        return summer.getValue();
    }

    public static long getRandomIcbmId(Random random) {
        return random.nextLong();
    }
}

