/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.dim;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DynAsciiCharSequence;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.Attachment;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.AttachmentSaver;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.Cancellable;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DrainingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.EnteringDrainModeEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.ReceivedAttachmentEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.ReceivedMessageEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.ReceivingAttachmentEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.ReceivingMessageEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractTransferrer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.PauseHelper;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.EventPost;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StreamInfo;
import org.jetbrains.annotations.Nullable;

public class DirectimReceiver
extends AbstractTransferrer {
    private static final Logger LOGGER = Logger.getLogger(DirectimReceiver.class.getName());
    private static final Pattern PATTERN_ID = Pattern.compile("ID=['\"]*(\\w+)[\"']*", 2);
    private static final Pattern PATTERN_SIZE = Pattern.compile("SIZE=['\"]*(\\w+)[\"']*", 2);
    private boolean autoResponse;
    private final String charset;
    private final AttachmentSaver saver;
    private final EventPost eventPost;
    @Nullable
    private final PauseHelper pauseHelper;
    @Nullable
    private final Cancellable cancellable;
    private ByteBuffer buffer;
    private DynAsciiCharSequence chars;
    private ByteArrayOutputStream msgBuffer;
    @Nullable
    private Selector selector;
    private Mode mode;
    private String lastid;
    private Attachment last;
    private long lastAttachmentReceived;
    private Long lastAttachmentSize;
    private boolean checkbuffer;
    private WritableByteChannel destchannel;

    public DirectimReceiver(StreamInfo stream, EventPost eventPost, @Nullable PauseHelper pauseHelper, AttachmentSaver saver, @Nullable Cancellable cancellable, String charset, long datalen, boolean autoResponse) {
        this(eventPost, pauseHelper, saver, cancellable, charset, datalen, stream.getReadableChannel(), stream.getSelectableChannel(), autoResponse);
    }

    public DirectimReceiver(EventPost eventPost, AttachmentSaver saver, String charset, long datalen, ReadableByteChannel readable, boolean autoResponse) {
        this(eventPost, null, saver, null, charset, datalen, readable, null, autoResponse);
    }

    public DirectimReceiver(EventPost eventPost, @Nullable PauseHelper pauseHelper, AttachmentSaver saver, @Nullable Cancellable cancellable, String charset, long datalen, ReadableByteChannel readable, @Nullable SelectableChannel selectable, boolean autoResponse) {
        super(readable, null, selectable, 0L, datalen);
        this.resizeBuffer(1024);
        this.msgBuffer = new ByteArrayOutputStream();
        this.mode = Mode.MESSAGE;
        this.lastid = null;
        this.last = null;
        this.lastAttachmentReceived = 0L;
        this.lastAttachmentSize = null;
        this.checkbuffer = false;
        this.destchannel = null;
        this.cancellable = cancellable;
        this.charset = charset;
        this.saver = saver;
        this.eventPost = eventPost;
        this.pauseHelper = pauseHelper;
        this.autoResponse = autoResponse;
    }

    public void resizeBuffer(int size) {
        this.buffer = ByteBuffer.allocate(size);
        this.chars = new DynAsciiCharSequence(ByteBlock.wrap((byte[])this.buffer.array()));
    }

    protected boolean isCancelled() {
        return this.cancellable != null && this.cancellable.isCancelled();
    }

    protected boolean waitIfPaused() {
        return this.pauseHelper != null && this.pauseHelper.waitUntilUnpause();
    }

    protected void waitUntilReady() throws IOException {
        if (this.checkbuffer) {
            return;
        }
        if (this.mode == Mode.DATA && this.selector != null) {
            this.selector.select(50L);
        }
        if (this.buffer.position() == 0) {
            super.waitUntilReady();
        }
    }

    protected long transferChunk(ReadableByteChannel readable, WritableByteChannel writable, long transferred, long remaining) throws IOException {
        int origpos = this.buffer.position();
        if (!(this.checkbuffer || this.mode != Mode.MESSAGE && this.mode != Mode.TAG || this.buffer.remaining() != 0)) {
            LOGGER.warning("DIM buffer full; entering drain mode from " + (Object)((Object)this.mode));
            this.eventPost.fireEvent(new EnteringDrainModeEvent(remaining));
            this.mode = Mode.DRAIN;
            this.checkbuffer = false;
            this.buffer.rewind();
            this.buffer.limit(this.buffer.capacity());
            return origpos;
        }
        this.buffer.limit((int)Math.min((long)this.buffer.capacity(), (long)this.buffer.position() + remaining));
        int read = readable.read(this.buffer);
        int actuallyRead = Math.max(read, 0);
        if (!(this.checkbuffer || read != -1 && this.mode != Mode.DRAIN)) {
            int skipped = this.buffer.position();
            this.buffer.rewind();
            this.buffer.limit(this.buffer.capacity());
            long progress = transferred + (long)actuallyRead;
            long total = transferred + remaining;
            this.eventPost.fireEvent(new DrainingEvent(progress, total));
            this.checkbuffer = false;
            return skipped;
        }
        this.checkbuffer = read > 0;
        this.chars.setLength(this.buffer.position());
        if (this.mode == Mode.MESSAGE || this.mode == Mode.TAG || this.mode == Mode.DRAIN) {
            int closeBracket;
            if (this.mode == Mode.MESSAGE) {
                int binaryPos = this.chars.indexOf((CharSequence)"<BINARY>");
                if (binaryPos != -1) {
                    int firstDataTag = binaryPos + "<BINARY>".length();
                    this.msgBuffer.write(this.buffer.array(), 0, binaryPos);
                    this.buffer.position(firstDataTag);
                    this.buffer.compact();
                    String message = new String(this.msgBuffer.toByteArray(), this.charset);
                    this.mode = Mode.TAG;
                    this.checkbuffer = true;
                    this.msgBuffer = null;
                    this.eventPost.fireEvent(new ReceivedMessageEvent(message, this.autoResponse));
                    return firstDataTag;
                }
                int writelen = remaining - (long)actuallyRead <= 7L ? this.buffer.position() : Math.max(0, this.buffer.position() - 7);
                if (writelen > 0) {
                    this.msgBuffer.write(this.buffer.array(), 0, writelen);
                    String message = new String(this.msgBuffer.toByteArray(), this.charset);
                    this.eventPost.fireEvent(new ReceivingMessageEvent(this.msgBuffer.size(), transferred + remaining, message));
                }
                int endpos = this.buffer.position();
                this.buffer.position(writelen);
                this.buffer.limit(endpos);
                this.buffer.compact();
                return writelen;
            }
            if (this.mode == Mode.TAG && (closeBracket = this.chars.indexOf((CharSequence)">")) != -1) {
                Matcher idm;
                DynAsciiCharSequence tag = this.chars.subSequence(0, closeBracket + 1);
                Matcher sizem = PATTERN_SIZE.matcher((CharSequence)tag);
                if (sizem.find()) {
                    try {
                        this.lastAttachmentSize = Long.parseLong(sizem.group(1));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((idm = PATTERN_ID.matcher((CharSequence)tag)).find()) {
                    this.lastid = idm.group(1);
                }
                if (this.lastAttachmentSize != null && this.lastid != null) {
                    this.mode = Mode.DATA;
                    this.last = this.saver.createChannel(this.lastid, this.lastAttachmentSize);
                    this.destchannel = this.last.openForWriting();
                    SelectableChannel destinationSel = this.last.getSelectableForWriting();
                    if (destinationSel != null) {
                        this.selector = Selector.open();
                        destinationSel.register(this.selector, 4);
                    } else {
                        this.selector = null;
                    }
                    this.checkbuffer = true;
                }
                this.buffer.limit(this.buffer.position());
                this.buffer.position(closeBracket + 1);
                this.buffer.compact();
            }
            if (!this.checkbuffer && actuallyRead == 0 && (long)origpos >= remaining) {
                return remaining;
            }
            return actuallyRead + origpos - this.buffer.position();
        }
        if (this.mode == Mode.DATA) {
            int wrote;
            this.buffer.flip();
            int origLimit = this.buffer.limit();
            if (this.lastAttachmentReceived + (long)this.buffer.remaining() > this.lastAttachmentSize) {
                this.buffer.limit((int)(this.lastAttachmentSize - this.lastAttachmentReceived));
            }
            if ((wrote = this.destchannel.write(this.buffer)) == -1) {
                return -1L;
            }
            this.lastAttachmentReceived += (long)wrote;
            this.eventPost.fireEvent(new ReceivingAttachmentEvent(transferred + (long)wrote, transferred + remaining, this.lastAttachmentReceived, this.last));
            if (this.lastAttachmentReceived >= this.lastAttachmentSize) {
                this.eventPost.fireEvent(new ReceivedAttachmentEvent(this.lastid, this.lastAttachmentSize, this.last));
                this.mode = Mode.TAG;
                this.lastid = null;
                this.lastAttachmentReceived = 0L;
                this.lastAttachmentSize = null;
                this.last = null;
                try {
                    this.destchannel.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Error closing attachment saver", e);
                }
                this.destchannel = null;
                if (this.selector != null) {
                    try {
                        this.selector.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Error closing attachment NIO selector", e);
                    }
                }
                this.checkbuffer = true;
            }
            if (wrote != read) {
                this.checkbuffer = true;
            }
            this.buffer.limit(origLimit);
            this.buffer.compact();
            return wrote;
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)this.mode));
    }

    protected void cleanUp() throws IOException {
        if (this.mode == Mode.MESSAGE) {
            this.msgBuffer.write(this.buffer.array(), 0, this.buffer.position());
            String msg = new String(this.msgBuffer.toByteArray(), this.charset);
            this.eventPost.fireEvent(new ReceivedMessageEvent(msg, this.autoResponse));
        } else if (this.mode == Mode.DATA) {
            // empty if block
        }
        if (this.selector != null) {
            this.selector.close();
        }
    }

    protected int getSelectionKey() {
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        MESSAGE,
        TAG,
        DATA,
        DRAIN;

    }
}

