/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.util.logging.Logger;
import net.kano.joscar.rv.RecvRvEvent;
import net.kano.joscar.rvcmd.ConnectionRequestRvCmd;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.AbstractRvSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingRvConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Initiator;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.NewIncomingConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ConnectToProxyForIncomingController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.OutgoingConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.RedirectToProxyController;

public abstract class AbstractIncomingRvSessionHandler
extends AbstractRvSessionHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractIncomingRvSessionHandler.class.getName());
    private final IncomingRvConnectionImpl incomingRvConnection;
    private boolean gotFirstRequest = false;

    public AbstractIncomingRvSessionHandler(IncomingRvConnectionImpl incomingRvConnection) {
        super(incomingRvConnection);
        this.incomingRvConnection = incomingRvConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleIncomingRequest(RecvRvEvent event, ConnectionRequestRvCmd reqCmd) {
        int index = reqCmd.getRequestIndex();
        if (index == 1) {
            AbstractIncomingRvSessionHandler abstractIncomingRvSessionHandler = this;
            synchronized (abstractIncomingRvSessionHandler) {
                if (this.gotFirstRequest) {
                    return;
                }
                this.gotFirstRequest = true;
            }
            this.handleFirstRequest(reqCmd);
            RvSessionConnectionInfo rvinfo = this.incomingRvConnection.getRvSessionInfo();
            rvinfo.setConnectionInfo(reqCmd.getConnInfo());
            rvinfo.setInitiator(Initiator.BUDDY);
            this.incomingRvConnection.getEventPost().fireEvent(new NewIncomingConnectionEvent(this.incomingRvConnection));
        } else if (index > 1) {
            AbstractRvSessionHandler.HowToConnect how = this.processRedirect(reqCmd);
            if (this.incomingRvConnection.isOpen()) {
                if (how == AbstractRvSessionHandler.HowToConnect.PROXY || how == AbstractRvSessionHandler.HowToConnect.NORMAL) {
                    boolean worked;
                    if (how == AbstractRvSessionHandler.HowToConnect.PROXY) {
                        worked = this.incomingRvConnection.changeStateController(new ConnectToProxyForIncomingController());
                    } else {
                        assert (how == AbstractRvSessionHandler.HowToConnect.NORMAL);
                        worked = this.incomingRvConnection.changeStateController(new OutgoingConnectionController(ConnectionType.LAN));
                    }
                    if (worked) {
                        this.incomingRvConnection.getRvSessionInfo().getRequestMaker().sendRvAccept();
                    }
                } else if (how == AbstractRvSessionHandler.HowToConnect.DONT) {
                    this.incomingRvConnection.changeStateController(new RedirectToProxyController());
                }
            }
        } else {
            LOGGER.warning("Got unknown request index " + index + " for " + reqCmd);
        }
    }

    protected abstract void handleFirstRequest(ConnectionRequestRvCmd var1);
}

