/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.net.ClientConn;
import net.kano.joustsim.JavaTools;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.OpenedServiceListener;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.ExternalConnection;
import net.kano.joustsim.oscar.oscar.OscarConnListener;
import net.kano.joustsim.oscar.oscar.OscarConnStateEvent;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.DefaultServiceArbiterFactory;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.ServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.ServiceArbiterFactory;
import net.kano.joustsim.oscar.oscar.service.ServiceArbitrationManager;
import net.kano.joustsim.oscar.oscar.service.ServiceFactory;
import net.kano.joustsim.oscar.oscar.service.ServiceListener;
import net.kano.joustsim.oscar.oscar.service.bos.ExternalBosService;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.bos.OpenedExternalServiceListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.RoomFinderServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.icon.IconServiceArbiter;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalServiceManager {
    private static final Logger LOGGER = Logger.getLogger(ExternalServiceManager.class.getName());
    private static final int DEFAULT_SERVICE_TIMEOUT = 10000;
    private final AimConnection aimConnection;
    private final Object externalServicesLock = new Object();
    private final Map<Integer, ServiceArbiter<? extends Service>> externalServices = new HashMap<Integer, ServiceArbiter<? extends Service>>();
    private final Map<ServiceArbiter<? extends Service>, OscarConnection> externalConnections = new HashMap<ServiceArbiter<? extends Service>, OscarConnection>();
    private final Map<Integer, ServiceRequestInfo<? extends Service>> pendingServiceRequests = new HashMap<Integer, ServiceRequestInfo<? extends Service>>();
    private final ServiceArbitrationManager arbitrationManager = new ServiceArbitrationManager(){

        @Override
        public void openService(ServiceArbiter<? extends Service> arbiter) {
            int family = arbiter.getSnacFamily();
            if (ExternalServiceManager.this.getServiceArbiter(family) == arbiter) {
                ExternalServiceManager.this.requestService(family, arbiter);
            }
        }
    };
    private final Timer serviceTimer = this.createServiceTimer();
    private ServiceArbiterFactory arbiterFactory = new DefaultServiceArbiterFactory();
    private volatile int serviceConnectionTimeout = 10000;

    public static int fixPort(int port) {
        int usePort = port <= 0 ? 5190 : port;
        return usePort;
    }

    public ExternalServiceManager(AimConnection aimConnection) {
        this.aimConnection = aimConnection;
        aimConnection.addStateListener(new StateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleStateChange(StateEvent event) {
                State newState = event.getNewState();
                if (newState.isFinished()) {
                    ArrayList vals;
                    ExternalServiceManager.this.serviceTimer.cancel();
                    ExternalServiceManager externalServiceManager = ExternalServiceManager.this;
                    synchronized (externalServiceManager) {
                        vals = new ArrayList(ExternalServiceManager.this.externalConnections.values());
                    }
                    for (OscarConnection conn : vals) {
                        conn.disconnect();
                    }
                }
            }
        });
        aimConnection.addOpenedServiceListener(new OpenedServiceListener(){

            @Override
            public void openedServices(AimConnection conn, Collection<? extends Service> services) {
                MainBosService bos = conn.getBosService();
                if (bos == null) {
                    return;
                }
                bos.addServiceListener(new ServiceListener(){

                    public void handleServiceReady(Service service) {
                        for (ServiceRequestInfo req : ExternalServiceManager.this.pendingServiceRequests.values()) {
                            ExternalServiceManager.this.updateServiceRequest(req);
                        }
                    }

                    public void handleServiceFinished(Service service) {
                    }
                });
            }

            @Override
            public void closedServices(AimConnection conn, Collection<? extends Service> services) {
            }
        });
    }

    public int getServiceConnectionTimeout() {
        return this.serviceConnectionTimeout;
    }

    public void setServiceConnectionTimeout(int serviceConnectionTimeout) {
        this.serviceConnectionTimeout = serviceConnectionTimeout;
    }

    private Timer createServiceTimer() {
        Timer serviceTimer = new Timer(true);
        serviceTimer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet retry = new HashSet();
                4 var2_2 = this;
                synchronized (var2_2) {
                    long time = System.currentTimeMillis();
                    Set entries = ExternalServiceManager.this.pendingServiceRequests.entrySet();
                    boolean changed = true;
                    block3: while (changed) {
                        changed = false;
                        Iterator it = entries.iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            ServiceRequestInfo request = (ServiceRequestInfo)entry.getValue();
                            long diff = time - request.getStartTime();
                            if (diff <= (long)ExternalServiceManager.this.serviceConnectionTimeout) continue;
                            LOGGER.info("External service for arbiter " + request.getArbiter() + "(0x" + Integer.toHexString(request.getFamily()) + ") timed out after " + (double)diff / 1000.0 + "s; retrying");
                            retry.add(entry.getKey());
                            request.cancel();
                            it.remove();
                            changed = true;
                            continue block3;
                        }
                    }
                }
                Iterator i$ = retry.iterator();
                while (i$.hasNext()) {
                    int service = (Integer)i$.next();
                    ExternalServiceManager.this.requestService(service, ExternalServiceManager.this.getServiceArbiter(service));
                }
            }
        }, 5000L, 5000L);
        return serviceTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ServiceArbiter<? extends Service> getServiceArbiter(int service) {
        ServiceArbiter<? extends Service> arbiter;
        Object object = this.externalServicesLock;
        synchronized (object) {
            arbiter = this.externalServices.get(service);
            if (arbiter != null) {
                return arbiter;
            }
            LOGGER.finer("Creating arbiter for service " + service);
            arbiter = this.arbiterFactory.getInstance(this.arbitrationManager, service);
            LOGGER.fine("Created arbiter for service " + service + ": " + arbiter);
            if (arbiter == null) {
                return null;
            }
            this.externalServices.put(service, arbiter);
        }
        this.requestService(service, arbiter);
        return arbiter;
    }

    public IconServiceArbiter getIconServiceArbiter() {
        return this.getArbiter(16, IconServiceArbiter.class);
    }

    public RoomFinderServiceArbiter getChatRoomFinderServiceArbiter() {
        return this.getArbiter(13, RoomFinderServiceArbiter.class);
    }

    private <A> A getArbiter(int family, Class<A> arbiterClass) {
        ServiceArbiter<? extends Service> arbiter = this.getServiceArbiter(family);
        if (arbiterClass.isInstance(arbiter)) {
            return JavaTools.cast(arbiterClass, arbiter);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshServiceIfNecessary(int family) {
        ServiceArbiter<? extends Service> arbiter;
        Object object = this.externalServicesLock;
        synchronized (object) {
            arbiter = this.externalServices.get(family);
        }
        if (arbiter == null) {
            LOGGER.warning("Someone requested refresh of 0x" + Integer.toHexString(family) + " but there's no arbiter");
            return;
        }
        if (!arbiter.shouldKeepAlive()) {
            LOGGER.log(Level.INFO, "Someone requested a refresh of 0x" + Integer.toHexString(family) + " but the arbiter " + arbiter + " says it doesn't want to live");
            return;
        }
        this.requestService(family, arbiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S extends Service> void requestService(int service, ServiceArbiter<S> arbiter) {
        ServiceRequestInfo<S> request;
        ExternalServiceManager externalServiceManager = this;
        synchronized (externalServiceManager) {
            if (this.pendingServiceRequests.containsKey(service)) {
                return;
            }
            if (this.externalConnections.containsKey(arbiter)) {
                LOGGER.finer("Someone requested 0x" + Integer.toHexString(service) + " but there's " + "already an external connection: " + this.externalConnections.get(arbiter));
                return;
            }
            request = new ServiceRequestInfo<S>(service, arbiter);
            this.pendingServiceRequests.put(service, request);
        }
        this.updateServiceRequest(request);
    }

    private <S extends Service> void updateServiceRequest(ServiceRequestInfo<S> request) {
        int family = request.getFamily();
        LOGGER.info("Requesting external service " + family + " for " + request.getArbiter());
        MainBosService bosService = this.aimConnection.getBosService();
        if (bosService == null) {
            return;
        }
        bosService.requestService(family, new ArbitratedExternalServiceListener<S>(request));
    }

    private synchronized <S extends Service> boolean clearRequest(ServiceRequestInfo<S> request) {
        boolean removed = this.pendingServiceRequests.values().remove(request);
        if (removed) {
            LOGGER.info("External connection request " + request + " cleared");
        } else {
            LOGGER.info("External connection request " + request + " was not cleared " + "because it is obsolete");
        }
        return removed;
    }

    private synchronized void clearExternalConnection(OscarConnection conn, ServiceArbiter<? extends Service> arbiter) {
        if (this.getExternalConnection(arbiter) == conn) {
            this.externalConnections.remove(arbiter);
        }
    }

    private synchronized OscarConnection getExternalConnection(ServiceArbiter<? extends Service> arbiter) {
        return this.externalConnections.get(arbiter);
    }

    private synchronized boolean storeExternalConnection(BasicConnection conn, ServiceRequestInfo<? extends Service> request) {
        if (!this.clearRequest(request)) {
            return false;
        }
        this.externalConnections.put(request.getArbiter(), conn);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArbitratedExternalServiceListener<S extends Service>
    implements OpenedExternalServiceListener {
        private final ServiceRequestInfo<S> request;

        public ArbitratedExternalServiceListener(ServiceRequestInfo<S> request) {
            this.request = request;
        }

        @Override
        public void handleServiceRedirect(MainBosService service, int serviceFamily, String host, int port, ByteBlock flapCookie) {
            LOGGER.fine("Connecting to " + host + ":" + port + " for external " + "service " + serviceFamily);
            ExternalConnection conn = new ExternalConnection(host, ExternalServiceManager.fixPort(port), serviceFamily);
            conn.getClientFlapConn().setSocketFactory(ExternalServiceManager.this.aimConnection.getProxy().getSocketFactory());
            conn.setCookie(flapCookie);
            conn.setServiceFactory(new ExternalServiceFactory<S>(serviceFamily, this.request.getArbiter()));
            conn.addOscarListener(new ExternalServiceConnListener<S>(serviceFamily, this.request));
            boolean isnew = ExternalServiceManager.this.storeExternalConnection(conn, this.request);
            if (isnew) {
                conn.connect();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExternalServiceConnListener<S extends Service>
    implements OscarConnListener {
        private final int serviceFamily;
        private final ServiceRequestInfo<S> request;

        public ExternalServiceConnListener(int serviceFamily, ServiceRequestInfo<S> arbiter) {
            this.request = arbiter;
            this.serviceFamily = serviceFamily;
        }

        @Override
        public void registeredSnacFamilies(OscarConnection conn) {
        }

        @Override
        public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
            ClientConn.State state = event.getClientConnEvent().getNewState();
            if (state == ClientConn.STATE_FAILED || state == ClientConn.STATE_NOT_CONNECTED) {
                LOGGER.info("External service connection died for service " + this.serviceFamily + " ( " + this.request + ")");
                conn.removeOscarListener(this);
                ExternalServiceManager.this.clearExternalConnection(conn, this.request.getArbiter());
                ExternalServiceManager.this.refreshServiceIfNecessary(this.serviceFamily);
            }
        }

        @Override
        public void allFamiliesReady(OscarConnection conn) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExternalServiceFactory<S extends Service>
    implements ServiceFactory {
        private final int serviceFamily;
        private final ServiceArbiter<S> arbiter;

        public ExternalServiceFactory(int serviceFamily, ServiceArbiter<S> arbiter) {
            this.serviceFamily = serviceFamily;
            this.arbiter = arbiter;
        }

        @Override
        public Service getService(OscarConnection conn, int family) {
            if (family == 1) {
                return new ExternalBosService(ExternalServiceManager.this.aimConnection, conn);
            }
            if (family == this.serviceFamily) {
                return this.arbiter.createService(ExternalServiceManager.this.aimConnection, conn);
            }
            LOGGER.warning("External service " + this.serviceFamily + " wants to open service " + family);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceRequestInfo<S extends Service> {
        private long startTime = System.currentTimeMillis();
        private int family;
        private ServiceArbiter<S> arbiter;
        private BasicConnection connection = null;
        private boolean canceled = false;

        public ServiceRequestInfo(int family, ServiceArbiter<S> arbiter) {
            this.family = family;
            this.arbiter = arbiter;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public ServiceArbiter<S> getArbiter() {
            return this.arbiter;
        }

        public synchronized BasicConnection getConnection() {
            return this.connection;
        }

        public synchronized void setConnection(BasicConnection connection) {
            this.connection = connection;
        }

        public void cancel() {
            this.canceled = true;
            BasicConnection connection = this.getConnection();
            if (connection != null) {
                connection.disconnect();
            }
        }

        public int getFamily() {
            return this.family;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public String toString() {
            return "<" + this.family + "> " + this.arbiter;
        }
    }
}

