/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.csrc;

import java.util.Map;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.RTPExtension;

public class SsrcTransformEngine
extends SinglePacketTransformer
implements TransformEngine {
    public static final String DROP_MUTED_AUDIO_SOURCE_IN_REVERSE_TRANSFORM = SsrcTransformEngine.class.getName() + ".dropMutedAudioSourceInReverseTransform";
    private final boolean dropMutedAudioSourceInReverseTransform;
    private MediaDirection ssrcAudioLevelDirection = MediaDirection.INACTIVE;
    private byte ssrcAudioLevelExtID = (byte)-1;

    public SsrcTransformEngine(MediaStreamImpl mediaStream) {
        Map<Byte, RTPExtension> activeRTPExtensions = mediaStream.getActiveRTPExtensions();
        if (activeRTPExtensions != null && !activeRTPExtensions.isEmpty()) {
            for (Map.Entry<Byte, RTPExtension> e : activeRTPExtensions.entrySet()) {
                RTPExtension rtpExtension = e.getValue();
                String uri = rtpExtension.getURI().toString();
                if (!"urn:ietf:params:rtp-hdrext:ssrc-audio-level".equals(uri)) continue;
                Byte extID = e.getKey();
                this.setSsrcAudioLevelExtensionID(extID == null ? (byte)-1 : (byte)extID, rtpExtension.getDirection());
            }
        }
        this.dropMutedAudioSourceInReverseTransform = false;
    }

    @Override
    public void close() {
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        byte level;
        if (this.ssrcAudioLevelExtID > 0 && this.ssrcAudioLevelDirection.allowsReceiving() && !pkt.isInvalid() && 2 == (pkt.readByte(0) & 0xC0) >>> 6 && (level = pkt.extractSsrcAudioLevel(this.ssrcAudioLevelExtID)) == 127) {
            if (this.dropMutedAudioSourceInReverseTransform) {
                pkt = null;
            } else {
                pkt.setFlags(4 | pkt.getFlags());
            }
        }
        return pkt;
    }

    public void setSsrcAudioLevelExtensionID(byte extID, MediaDirection dir) {
        this.ssrcAudioLevelExtID = extID;
        this.ssrcAudioLevelDirection = dir;
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        return pkt;
    }
}

