/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.configuration;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import net.java.sip.communicator.impl.configuration.JdbcConfigService;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ConfigurationActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(ConfigurationActivator.class);
    private ConfigurationService cs;

    public void start(BundleContext bundleContext) throws Exception {
        FileAccessService fas = (FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class);
        if (fas != null) {
            File useDatabaseConfig;
            try {
                useDatabaseConfig = fas.getPrivatePersistentFile(".usedatabaseconfig", FileCategory.PROFILE);
            }
            catch (IllegalStateException ise) {
                useDatabaseConfig = null;
            }
            if (useDatabaseConfig != null && useDatabaseConfig.exists()) {
                logger.info((Object)"Using database configuration store.");
                this.cs = new JdbcConfigService(fas);
            }
        }
        if (this.cs == null) {
            this.cs = LibJitsi.getConfigurationService();
        }
        bundleContext.registerService(ConfigurationService.class.getName(), (Object)this.cs, null);
        ConfigurationActivator.fixPermissions(this.cs);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.cs.storeConfiguration();
        this.cs = null;
    }

    private static void fixPermissions(ConfigurationService cs) {
        block5: {
            if (!OSUtils.IS_LINUX && !OSUtils.IS_MAC) {
                return;
            }
            try {
                File cf;
                File homeFolder = new File(cs.getScHomeDirLocation(), cs.getScHomeDirName());
                CLibrary libc = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);
                libc.chmod(homeFolder.getAbsolutePath(), 448);
                String fileName = cs.getConfigurationFilename();
                if (fileName != null && (cf = new File(homeFolder, fileName)).exists()) {
                    libc.chmod(cf.getAbsolutePath(), 384);
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error creating c lib instance for fixing file permissions", t);
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)t;
            }
        }
    }

    public static interface CLibrary
    extends Library {
        public int chmod(String var1, int var2);
    }
}

