/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.colibri;

import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.service.neomedia.MediaDirection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;

public class ColibriIQProvider
implements IQProvider {
    public ColibriIQProvider() {
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addExtensionProvider("payload-type", "http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<PayloadTypePacketExtension>(PayloadTypePacketExtension.class));
        providerManager.addExtensionProvider("source", "urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourcePacketExtension>(SourcePacketExtension.class));
        DefaultPacketExtensionProvider<ParameterPacketExtension> parameterProvider = new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class);
        providerManager.addExtensionProvider("parameter", "http://jitsi.org/protocol/colibri", parameterProvider);
        providerManager.addExtensionProvider("parameter", "urn:xmpp:jingle:apps:rtp:ssma:0", parameterProvider);
    }

    private void addChildExtension(ColibriConferenceIQ.Channel channel, PacketExtension childExtension) {
        if (childExtension instanceof PayloadTypePacketExtension) {
            PayloadTypePacketExtension payloadType = (PayloadTypePacketExtension)childExtension;
            if ("opus".equals(payloadType.getName()) && payloadType.getChannels() != 2) {
                payloadType.setChannels(2);
            }
            channel.addPayloadType(payloadType);
        } else if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            channel.setTransport(transport);
        }
    }

    private PacketExtension parseExtension(XmlPullParser parser, String name, String namespace) throws Exception {
        PacketExtension extension;
        PacketExtensionProvider extensionProvider = (PacketExtensionProvider)ProviderManager.getInstance().getExtensionProvider(name, namespace);
        if (extensionProvider == null) {
            this.throwAway(parser, name);
            extension = null;
        } else {
            extension = extensionProvider.parseExtension(parser);
        }
        return extension;
    }

    public IQ parseIQ(XmlPullParser parser) throws Exception {
        ColibriConferenceIQ iq;
        String namespace = parser.getNamespace();
        if ("conference".equals(parser.getName()) && "http://jitsi.org/protocol/colibri".equals(namespace)) {
            ColibriConferenceIQ conference = new ColibriConferenceIQ();
            String conferenceID = parser.getAttributeValue("", "id");
            if (conferenceID != null && conferenceID.length() != 0) {
                conference.setID(conferenceID);
            }
            boolean done = false;
            ColibriConferenceIQ.Channel channel = null;
            ColibriConferenceIQ.Content content = null;
            StringBuilder ssrc = null;
            block5: while (!done) {
                switch (parser.next()) {
                    case 3: {
                        String name = parser.getName();
                        if ("conference".equals(name)) {
                            done = true;
                            break;
                        }
                        if ("channel".equals(name)) {
                            content.addChannel(channel);
                            channel = null;
                            break;
                        }
                        if ("ssrc".equals(name)) {
                            String s = ssrc.toString().trim();
                            if (s.length() != 0) {
                                int i = s.startsWith("-") ? Integer.parseInt(s) : (int)Long.parseLong(s);
                                channel.addSSRC(i);
                            }
                            ssrc = null;
                            break;
                        }
                        if (!"content".equals(name)) break;
                        conference.addContent(content);
                        content = null;
                        break;
                    }
                    case 2: {
                        String name = parser.getName();
                        if ("channel".equals(name)) {
                            String rtpPort;
                            String rtpLevelRelayType;
                            String rtcpPort;
                            String lastN;
                            String initiator;
                            String channelID;
                            String host;
                            String expire;
                            String endpoint;
                            channel = new ColibriConferenceIQ.Channel();
                            String direction = parser.getAttributeValue("", "direction");
                            if (direction != null && direction.length() != 0) {
                                channel.setDirection(MediaDirection.parseString((String)direction));
                            }
                            if ((endpoint = parser.getAttributeValue("", "endpoint")) != null && endpoint.length() != 0) {
                                channel.setEndpoint(endpoint);
                            }
                            if ((expire = parser.getAttributeValue("", "expire")) != null && expire.length() != 0) {
                                channel.setExpire(Integer.parseInt(expire));
                            }
                            if ((host = parser.getAttributeValue("", "host")) != null && host.length() != 0) {
                                channel.setHost(host);
                            }
                            if ((channelID = parser.getAttributeValue("", "id")) != null && channelID.length() != 0) {
                                channel.setID(channelID);
                            }
                            if ((initiator = parser.getAttributeValue("", "initiator")) != null && initiator.length() != 0) {
                                channel.setInitiator(Boolean.valueOf(initiator));
                            }
                            if ((lastN = parser.getAttributeValue("", "last-n")) != null && lastN.length() != 0) {
                                channel.setLastN(Integer.parseInt(lastN));
                            }
                            if ((rtcpPort = parser.getAttributeValue("", "rtcpport")) != null && rtcpPort.length() != 0) {
                                channel.setRTCPPort(Integer.parseInt(rtcpPort));
                            }
                            if ((rtpLevelRelayType = parser.getAttributeValue("", "rtp-level-relay-type")) != null && rtpLevelRelayType.length() != 0) {
                                channel.setRTPLevelRelayType(rtpLevelRelayType);
                            }
                            if ((rtpPort = parser.getAttributeValue("", "rtpport")) == null || rtpPort.length() == 0) continue block5;
                            channel.setRTPPort(Integer.parseInt(rtpPort));
                            break;
                        }
                        if ("ssrc".equals(name)) {
                            ssrc = new StringBuilder();
                            break;
                        }
                        if ("content".equals(name)) {
                            content = new ColibriConferenceIQ.Content();
                            String contentName = parser.getAttributeValue("", "name");
                            if (contentName == null || contentName.length() == 0) continue block5;
                            content.setName(contentName);
                            break;
                        }
                        if (channel == null) break;
                        String peName = null;
                        String peNamespace = null;
                        if ("transport".equals(name) && "urn:xmpp:jingle:transports:ice-udp:1".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:transports:ice-udp:1";
                        } else if ("payload-type".equals(name)) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("transport".equals(name) && "urn:xmpp:jingle:transports:raw-udp:1".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:transports:raw-udp:1";
                        } else if ("source".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        }
                        if (peName == null) {
                            this.throwAway(parser, name);
                            break;
                        }
                        PacketExtension extension = this.parseExtension(parser, peName, peNamespace);
                        if (extension == null) continue block5;
                        this.addChildExtension(channel, extension);
                        break;
                    }
                    case 4: {
                        if (ssrc == null) break;
                        ssrc.append(parser.getText());
                    }
                }
            }
            iq = conference;
        } else {
            iq = null;
        }
        return iq;
    }

    private void throwAway(XmlPullParser parser, String name) throws Exception {
        while (3 != parser.next() || !name.equals(parser.getName())) {
        }
    }
}

