/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnList;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.BasicMessenger;
import net.sf.jml.protocol.outgoing.OutgoingADC;
import net.sf.jml.protocol.outgoing.OutgoingADD;
import net.sf.jml.protocol.outgoing.OutgoingADG;
import net.sf.jml.protocol.outgoing.OutgoingREA;
import net.sf.jml.protocol.outgoing.OutgoingREG;
import net.sf.jml.protocol.outgoing.OutgoingREM;
import net.sf.jml.protocol.outgoing.OutgoingRMG;
import net.sf.jml.protocol.outgoing.OutgoingXFR;

public class SimpleMessenger
extends BasicMessenger {
    SimpleMessenger(Email email, String string) {
        super(email, string);
    }

    public void newSwitchboard(Object object) {
        OutgoingXFR outgoingXFR = new OutgoingXFR(this.getActualMsnProtocol());
        outgoingXFR.setAttachment(object);
        this.send(outgoingXFR);
    }

    public void addGroup(String string) {
        if (string == null) {
            return;
        }
        OutgoingADG outgoingADG = new OutgoingADG(this.getActualMsnProtocol());
        outgoingADG.setGroupName(string);
        this.send(outgoingADG);
    }

    public void removeGroup(String string) {
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        if (msnGroup != null) {
            OutgoingRMG outgoingRMG = new OutgoingRMG(this.getActualMsnProtocol());
            outgoingRMG.setGroupId(string);
            this.send(outgoingRMG);
        }
    }

    public void renameGroup(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        if (msnGroup != null && !msnGroup.isDefaultGroup() && !msnGroup.getGroupName().equals(string2)) {
            OutgoingREG outgoingREG = new OutgoingREG(this.getActualMsnProtocol());
            outgoingREG.setGroupId(string);
            outgoingREG.setGroupName(string2);
            this.send(outgoingREG);
        }
    }

    private void addFriend(MsnList msnList, Email email, String string) {
        if (msnList == null || email == null || msnList == MsnList.RL || msnList == MsnList.PL) {
            return;
        }
        MsnProtocol msnProtocol = this.getActualMsnProtocol();
        if (msnProtocol.after(MsnProtocol.MSNP9)) {
            OutgoingADC outgoingADC = new OutgoingADC(msnProtocol);
            outgoingADC.setAddtoList(msnList);
            outgoingADC.setEmail(email);
            if (msnList == MsnList.FL) {
                outgoingADC.setFriendlyName(string == null ? email.getEmailAddress() : string);
            }
            this.send(outgoingADC);
        } else {
            OutgoingADD outgoingADD = new OutgoingADD(msnProtocol);
            outgoingADD.setAddtoList(msnList);
            outgoingADD.setEmail(email);
            outgoingADD.setFriendlyName(string == null ? email.getEmailAddress() : string);
            this.send(outgoingADD);
        }
    }

    private void removeFriend(MsnList msnList, Email email, String string, String string2) {
        if (msnList == null || msnList == MsnList.RL) {
            return;
        }
        if (msnList == MsnList.FL ? string == null : email == null) {
            return;
        }
        OutgoingREM outgoingREM = new OutgoingREM(this.getActualMsnProtocol());
        outgoingREM.setRemoveFromList(msnList);
        if (msnList == MsnList.FL) {
            outgoingREM.setId(string);
            if (string2 != null) {
                outgoingREM.setGroupId(string2);
            }
        } else {
            outgoingREM.setEmail(email);
        }
        this.send(outgoingREM);
    }

    public void addFriend(Email email, String string) {
        MsnContact msnContact;
        if (email == null) {
            return;
        }
        if (string == null) {
            string = email.getEmailAddress();
        }
        if ((msnContact = this.getContactList().getContactByEmail(email)) != null) {
            if (!msnContact.isInList(MsnList.FL)) {
                this.addFriend(MsnList.FL, email, string);
            }
            if (!msnContact.isInList(MsnList.AL)) {
                this.addFriend(MsnList.AL, email, string);
            }
        } else {
            this.addFriend(MsnList.FL, email, string);
            this.addFriend(MsnList.AL, email, string);
        }
    }

    public void blockFriend(Email email) {
        this.removeFriend(MsnList.AL, email, null, null);
        this.addFriend(MsnList.BL, email, null);
    }

    public void copyFriend(Email email, String string) {
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        if (msnContact == null || msnGroup == null || msnGroup.isDefaultGroup()) {
            return;
        }
        MsnProtocol msnProtocol = this.getActualMsnProtocol();
        if (msnProtocol.after(MsnProtocol.MSNP9)) {
            OutgoingADC outgoingADC = new OutgoingADC(msnProtocol);
            outgoingADC.setAddtoList(MsnList.FL);
            outgoingADC.setId(msnContact.getId());
            outgoingADC.setGroupId(string);
            this.send(outgoingADC);
        } else {
            OutgoingADD outgoingADD = new OutgoingADD(msnProtocol);
            outgoingADD.setAddtoList(MsnList.FL);
            outgoingADD.setEmail(email);
            outgoingADD.setFriendlyName(msnContact.getFriendlyName());
            outgoingADD.setGroupId(string);
            this.send(outgoingADD);
        }
    }

    public void moveFriend(Email email, String string, String string2) {
        if (email == null) {
            return;
        }
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        MsnGroup msnGroup2 = this.getContactList().getGroup(string2);
        if (msnGroup == null || msnGroup2 == null || msnGroup.equals(msnGroup2)) {
            return;
        }
        if (msnGroup2.isDefaultGroup()) {
            this.removeFriend(email, string);
        } else {
            this.copyFriend(email, string2);
            if (!msnGroup.isDefaultGroup()) {
                this.removeFriend(email, string);
            }
        }
    }

    public void removeFriend(Email email, boolean bl) {
        if (email == null) {
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact != null) {
            this.removeFriend(MsnList.FL, email, msnContact.getId(), null);
            if (bl) {
                this.blockFriend(email);
            }
        }
    }

    public void removeFriend(Email email, String string) {
        if (email == null) {
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact != null) {
            this.removeFriend(MsnList.FL, email, msnContact.getId(), string);
        }
    }

    public void renameFriend(Email email, String string) {
        if (email == null || string == null) {
            return;
        }
        MsnContact msnContact = this.getContactList().getContactByEmail(email);
        if (msnContact != null) {
            OutgoingREA outgoingREA = new OutgoingREA(this.getActualMsnProtocol());
            outgoingREA.setId(msnContact.getId());
            outgoingREA.setFriendlyName(string);
            this.send(outgoingREA);
        }
    }

    public void unblockFriend(Email email) {
        this.removeFriend(MsnList.BL, email, null, null);
        this.addFriend(MsnList.AL, email, null);
    }
}

