/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacket;

public class FlapErrorCmd
extends FlapCommand {
    public static final int CHANNEL_ERROR = 3;
    private final int code;

    protected FlapErrorCmd(FlapPacket flapPacket) {
        super(3);
        DefensiveTools.checkNull(flapPacket, "packet");
        ByteBlock byteBlock = flapPacket.getData();
        this.code = BinaryTools.getUShort(byteBlock, 0);
    }

    public FlapErrorCmd(int n) {
        super(3);
        DefensiveTools.checkRange(n, "code", 0);
        this.code = n;
    }

    public final int getErrorCode() {
        return this.code;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.code);
    }

    public String toString() {
        return "FlapErrorCmd: code=0x" + Integer.toHexString(this.code);
    }
}

