/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.msnslp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jml.protocol.msnslp.MsnslpMessage;
import net.sf.jml.util.NumberUtils;

public class MsnslpRequest
extends MsnslpMessage {
    private static Pattern pattern = Pattern.compile("(\\S+) (\\S+) MSNSLP/(\\d+)\\.(\\d+)");
    private String requestMethod;
    private String requestURI;

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String string) {
        this.requestMethod = string;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String string) {
        this.requestURI = string;
    }

    protected boolean readFirstLine(String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            this.setRequestMethod(matcher.group(1));
            this.setRequestURI(matcher.group(2));
            this.setMajorVersion(NumberUtils.stringToInt(matcher.group(3)));
            this.setMinorVersion(NumberUtils.stringToInt(matcher.group(4)));
            return true;
        }
        return false;
    }

    protected void writeFirstLine(StringBuffer stringBuffer) {
        stringBuffer.append(this.requestMethod).append(" ");
        stringBuffer.append(this.requestURI).append(" ");
        stringBuffer.append("MSNSLP/").append(this.getMajorVersion()).append('.').append(this.getMinorVersion());
    }
}

