/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.Iterator;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.XHTMLExtension;

public class XHTMLManager {
    private static final String namespace = "http://jabber.org/protocol/xhtml-im";

    public static Iterator getBodies(Message message) {
        XHTMLExtension xhtmlExtension = (XHTMLExtension)message.getExtension("html", namespace);
        if (xhtmlExtension != null) {
            return xhtmlExtension.getBodies();
        }
        return null;
    }

    public static void addBody(Message message, String body) {
        XHTMLExtension xhtmlExtension = (XHTMLExtension)message.getExtension("html", namespace);
        if (xhtmlExtension == null) {
            xhtmlExtension = new XHTMLExtension();
            message.addExtension(xhtmlExtension);
        }
        xhtmlExtension.addBody(body);
    }

    public static boolean isXHTMLMessage(Message message) {
        return message.getExtension("html", namespace) != null;
    }

    public static synchronized void setServiceEnabled(Connection connection, boolean enabled) {
        if (XHTMLManager.isServiceEnabled(connection) == enabled) {
            return;
        }
        if (enabled) {
            ServiceDiscoveryManager.getInstanceFor(connection).addFeature(namespace);
        } else {
            ServiceDiscoveryManager.getInstanceFor(connection).removeFeature(namespace);
        }
    }

    public static boolean isServiceEnabled(Connection connection) {
        return ServiceDiscoveryManager.getInstanceFor(connection).includesFeature(namespace);
    }

    public static boolean isServiceEnabled(Connection connection, String userID) {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(userID);
            return result.containsFeature(namespace);
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                XHTMLManager.setServiceEnabled(connection, true);
            }
        });
    }
}

