/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.FatalSqlExceptionHelper;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class ProxoolDriver
implements Driver {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$ProxoolDriver == null ? (class$org$logicalcobwebs$proxool$ProxoolDriver = ProxoolDriver.class$("org.logicalcobwebs.proxool.ProxoolDriver")) : class$org$logicalcobwebs$proxool$ProxoolDriver));
    private static final ResourceBundle ATTRIBUTE_DESCRIPTIONS_RESOURCE;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxoolDriver;

    private static ResourceBundle createAttributeDescriptionsResource() {
        try {
            return ResourceBundle.getBundle("org.logicalcobwebs.proxool.resources.attributeDescriptions");
        }
        catch (Exception e) {
            LOG.error((Object)"Could not find resource org.logicalcobwebs.proxool.resources.attributeDescriptions", (Throwable)e);
            return null;
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!url.startsWith("proxool")) {
            return null;
        }
        ConnectionPool cp = null;
        try {
            String alias = ProxoolFacade.getAlias(url);
            if (!ConnectionPoolManager.getInstance().isPoolExists(alias)) {
                ProxoolFacade.registerConnectionPool(url, info, false);
                cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
            } else if (info != null && info.size() > 0) {
                cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
                ConnectionPoolDefinition cpd = cp.getDefinition();
                if (!cpd.isEqual(url, info)) {
                    cpd.redefine(url, info);
                }
            } else {
                cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
            }
            return cp.getConnection();
        }
        catch (SQLException e) {
            try {
                String alias = ProxoolFacade.getAlias(url);
                cp = ConnectionPoolManager.getInstance().getConnectionPool(alias);
                if (FatalSqlExceptionHelper.testException(cp.getDefinition(), e)) {
                    FatalSqlExceptionHelper.throwFatalSQLException(cp.getDefinition().getFatalSqlExceptionWrapper(), e);
                }
                throw e;
            }
            catch (ProxoolException e1) {
                LOG.error((Object)"Problem", (Throwable)e);
                throw new SQLException(e.toString());
            }
        }
        catch (ProxoolException e) {
            LOG.error((Object)"Problem", (Throwable)e);
            throw new SQLException(e.toString());
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("proxool");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[18];
        ConnectionPool cp = null;
        try {
            cp = ConnectionPoolManager.getInstance().getConnectionPool(url);
        }
        catch (ProxoolException e) {
            throw new SQLException(e.toString());
        }
        ConnectionPoolDefinition cpd = cp.getDefinition();
        dpi[0] = this.buildDriverPropertyInfo("proxool.driver", String.valueOf(cpd.getDriver()));
        dpi[1] = this.buildDriverPropertyInfo("proxool.url", String.valueOf(cpd.getUrl()));
        dpi[2] = this.buildDriverPropertyInfo("proxool.minimum-connection-count", String.valueOf(cpd.getMinimumConnectionCount()));
        dpi[3] = this.buildDriverPropertyInfo("proxool.maximum-connection-count", String.valueOf(cpd.getMaximumConnectionCount()));
        dpi[4] = this.buildDriverPropertyInfo("proxool.maximum-connection-lifetime", String.valueOf(cpd.getMaximumConnectionLifetime()));
        dpi[5] = this.buildDriverPropertyInfo("proxool.maximum-new-connections", String.valueOf(cpd.getMaximumNewConnections()));
        dpi[6] = this.buildDriverPropertyInfo("proxool.prototype-count", String.valueOf(cpd.getPrototypeCount()));
        dpi[7] = this.buildDriverPropertyInfo("proxool.house-keeping-sleep-time", String.valueOf(cpd.getHouseKeepingSleepTime()));
        dpi[8] = this.buildDriverPropertyInfo("proxool.house-keeping-test-sql", cpd.getHouseKeepingTestSql());
        dpi[9] = this.buildDriverPropertyInfo("proxool.recently-started-threshold", String.valueOf(cpd.getRecentlyStartedThreshold()));
        dpi[10] = this.buildDriverPropertyInfo("proxool.overload-without-refusal-lifetime", String.valueOf(cpd.getOverloadWithoutRefusalLifetime()));
        dpi[11] = this.buildDriverPropertyInfo("proxool.maximum-active-time", String.valueOf(cpd.getMaximumActiveTime()));
        dpi[12] = this.buildDriverPropertyInfo("proxool.verbose", String.valueOf(cpd.isVerbose()));
        dpi[13] = this.buildDriverPropertyInfo("proxool.trace", String.valueOf(cpd.isTrace()));
        dpi[14] = this.buildDriverPropertyInfo("proxool.fatal-sql-exception", String.valueOf(cpd.getFatalSqlExceptions()));
        dpi[15] = this.buildDriverPropertyInfo("proxool.fatal-sql-exception", String.valueOf(cpd.getFatalSqlExceptions()));
        dpi[16] = this.buildDriverPropertyInfo("proxool.statistics", String.valueOf(cpd.getStatistics()));
        dpi[17] = this.buildDriverPropertyInfo("proxool.statistics-log-level", String.valueOf(cpd.getStatisticsLogLevel()));
        return dpi;
    }

    private DriverPropertyInfo buildDriverPropertyInfo(String propertyName, String value) {
        DriverPropertyInfo dpi = new DriverPropertyInfo(propertyName, ATTRIBUTE_DESCRIPTIONS_RESOURCE.getString(propertyName));
        if (value != null) {
            dpi.value = value;
        }
        return dpi;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new ProxoolDriver());
        }
        catch (SQLException e) {
            System.out.println(e.toString());
        }
        ATTRIBUTE_DESCRIPTIONS_RESOURCE = ProxoolDriver.createAttributeDescriptionsResource();
    }
}

