/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cryptozrtp.generators;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.cryptozrtp.generators.DHParametersHelper;
import org.bouncycastle.cryptozrtp.params.DHParameters;

public class DHParametersGenerator {
    private int size;
    private int certainty;
    private RandomGenerator random;
    private static final BigIntegerCrypto TWO = BigIntegerCrypto.valueOf(2L);

    public void init(int size, int certainty, RandomGenerator random) {
        this.size = size;
        this.certainty = certainty;
        this.random = random;
    }

    public DHParameters generateParameters() {
        BigIntegerCrypto[] safePrimes = DHParametersHelper.generateSafePrimes(this.size, this.certainty, this.random);
        BigIntegerCrypto p = safePrimes[0];
        BigIntegerCrypto q = safePrimes[1];
        BigIntegerCrypto g = DHParametersHelper.selectGenerator(p, q, this.random);
        return new DHParameters(p, g, q, TWO, null);
    }
}

