/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.csrc;

import java.util.Map;
import org.jitsi.impl.neomedia.AudioMediaStreamImpl;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.RTPExtension;

public class CsrcTransformEngine
implements TransformEngine,
PacketTransformer {
    private final MediaStreamImpl mediaStream;
    private byte csrcAudioLevelExtID = (byte)-1;
    private byte[] extensionBuff = null;
    private int extensionBuffLen = 0;
    private CsrcAudioLevelDispatcher csrcLevelDispatcher = null;
    private MediaDirection audioLevelDirection = MediaDirection.INACTIVE;

    public CsrcTransformEngine(MediaStreamImpl stream) {
        this.mediaStream = stream;
        Map<Byte, RTPExtension> activeRTPExtensions = this.mediaStream.getActiveRTPExtensions();
        if (activeRTPExtensions != null && !activeRTPExtensions.isEmpty()) {
            for (Map.Entry<Byte, RTPExtension> e : activeRTPExtensions.entrySet()) {
                Byte extensionID = e.getKey();
                RTPExtension rtpExtension = e.getValue();
                if (!"urn:ietf:params:rtp-hdrext:csrc-audio-level".equals(rtpExtension.getURI().toString())) continue;
                this.setCsrcAudioLevelAudioLevelExtensionID(extensionID == null ? (byte)-1 : (byte)extensionID, rtpExtension.getDirection());
            }
        }
    }

    @Override
    public void close() {
        if (this.csrcLevelDispatcher != null) {
            this.csrcLevelDispatcher.stop();
        }
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        long[] levels;
        if (this.csrcAudioLevelExtID > 0 && this.audioLevelDirection.allowsReceiving() && (levels = pkt.extractCsrcLevels(this.csrcAudioLevelExtID)) != null) {
            if (this.csrcLevelDispatcher == null) {
                this.csrcLevelDispatcher = new CsrcAudioLevelDispatcher();
                new Thread(this.csrcLevelDispatcher).start();
            }
            this.csrcLevelDispatcher.addLevels(levels);
        }
        return pkt;
    }

    @Override
    public synchronized RawPacket transform(RawPacket pkt) {
        if (pkt.getExtensionBit()) {
            return pkt;
        }
        long[] csrcList = this.mediaStream.getLocalContributingSourceIDs();
        if (csrcList == null || csrcList.length == 0) {
            return pkt;
        }
        pkt.setCsrcList(csrcList);
        if (this.csrcAudioLevelExtID > 0 && this.audioLevelDirection.allowsSending() && this.mediaStream instanceof AudioMediaStreamImpl) {
            byte[] levelsExt = this.createLevelExtensionBuffer(csrcList);
            pkt.addExtension(levelsExt, this.extensionBuffLen);
        }
        return pkt;
    }

    public void setCsrcAudioLevelAudioLevelExtensionID(byte extID, MediaDirection dir) {
        this.csrcAudioLevelExtID = extID;
        this.audioLevelDirection = dir;
    }

    private byte[] createLevelExtensionBuffer(long[] csrcList) {
        int buffLen = 1 + csrcList.length;
        int padLen = 4 - buffLen % 4;
        if (padLen == 4) {
            padLen = 0;
        }
        byte[] extensionBuff = this.getExtensionBuff(buffLen += padLen);
        extensionBuff[0] = (byte)(this.csrcAudioLevelExtID << 4 | csrcList.length - 1);
        int csrcOffset = 1;
        for (int i = 0; i < csrcList.length; ++i) {
            byte level;
            long csrc = csrcList[i];
            extensionBuff[csrcOffset] = level = (byte)((AudioMediaStreamImpl)this.mediaStream).getLastMeasuredAudioLevel(csrc);
            ++csrcOffset;
        }
        return extensionBuff;
    }

    private byte[] getExtensionBuff(int ensureCapacity) {
        if (this.extensionBuff == null || this.extensionBuff.length < ensureCapacity) {
            this.extensionBuff = new byte[ensureCapacity];
        }
        this.extensionBuffLen = ensureCapacity;
        return this.extensionBuff;
    }

    private class CsrcAudioLevelDispatcher
    implements Runnable {
        private boolean isRunning = false;
        private long[] lastReportedLevels = null;

        private CsrcAudioLevelDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.isRunning = true;
            if (!(CsrcTransformEngine.this.mediaStream instanceof AudioMediaStreamImpl)) {
                return;
            }
            AudioMediaStreamImpl audioStream = (AudioMediaStreamImpl)CsrcTransformEngine.this.mediaStream;
            while (this.isRunning) {
                long[] audioLevels;
                CsrcAudioLevelDispatcher csrcAudioLevelDispatcher = this;
                synchronized (csrcAudioLevelDispatcher) {
                    if (this.lastReportedLevels == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        continue;
                    }
                    audioLevels = this.lastReportedLevels;
                    this.lastReportedLevels = null;
                }
                if (audioLevels == null) continue;
                audioStream.audioLevelsReceived(audioLevels);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLevels(long[] levels) {
            CsrcAudioLevelDispatcher csrcAudioLevelDispatcher = this;
            synchronized (csrcAudioLevelDispatcher) {
                this.lastReportedLevels = levels;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            CsrcAudioLevelDispatcher csrcAudioLevelDispatcher = this;
            synchronized (csrcAudioLevelDispatcher) {
                this.lastReportedLevels = null;
                this.isRunning = false;
                this.notifyAll();
            }
        }
    }
}

