/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidateType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.ComponentImpl;
import org.jitsi.videobridge.TransportManager;
import org.osgi.framework.BundleContext;

public class RawUdpTransportManager
extends TransportManager {
    private final int generation;
    private final String rtcpCandidateID;
    private final String rtpCandidateID;
    private final StreamConnector streamConnector = this.createStreamConnector();

    public RawUdpTransportManager(Channel channel) throws IOException {
        super(channel);
        this.generation = 0;
        this.rtpCandidateID = this.generateCandidateID();
        this.rtcpCandidateID = this.generateCandidateID();
    }

    public void close() {
        super.close();
        if (this.streamConnector != null) {
            this.streamConnector.close();
        }
    }

    private StreamConnector createStreamConnector() throws IOException {
        String domain;
        ComponentImpl component = this.getChannel().getContent().getConference().getVideobridge().getComponent();
        BundleContext bundleContext = component.getBundleContext();
        NetworkAddressManagerService nams = (NetworkAddressManagerService)ServiceUtils.getService((BundleContext)bundleContext, NetworkAddressManagerService.class);
        InetAddress bindAddr = null;
        if (nams != null && (domain = component.getDomain()) != null && domain.length() != 0) {
            int subdomainEnd = domain.indexOf(46);
            if (subdomainEnd >= 0) {
                domain = domain.substring(subdomainEnd + 1);
            }
            if (domain.length() != 0) {
                try {
                    bindAddr = nams.getLocalHost(NetworkUtils.getInetAddress((String)domain));
                }
                catch (UnknownHostException uhe) {
                    uhe.printStackTrace(System.err);
                }
            }
        }
        if (bindAddr == null) {
            bindAddr = InetAddress.getLocalHost();
        }
        DefaultStreamConnector streamConnector = new DefaultStreamConnector(bindAddr);
        streamConnector.getDataSocket();
        streamConnector.getControlSocket();
        return streamConnector;
    }

    public void describe(ColibriConferenceIQ.Channel iq) {
        super.describe(iq);
        IceUdpTransportPacketExtension transport = iq.getTransport();
        if (transport != null) {
            String host = null;
            int rtcpPort = 0;
            int rtpPort = 0;
            block4: for (CandidatePacketExtension candidate : transport.getCandidateList()) {
                switch (candidate.getComponent()) {
                    case 2: {
                        rtcpPort = candidate.getPort();
                        break;
                    }
                    case 1: {
                        rtpPort = candidate.getPort();
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                if (host != null && host.length() != 0) continue;
                host = candidate.getIP();
            }
            iq.setHost(host);
            iq.setRTCPPort(rtcpPort);
            iq.setRTPPort(rtpPort);
        }
    }

    protected void describe(IceUdpTransportPacketExtension pe) {
        StreamConnector streamConnector = this.getStreamConnector();
        DatagramSocket socket = streamConnector.getDataSocket();
        CandidatePacketExtension candidate = new CandidatePacketExtension();
        candidate.setComponent(1);
        candidate.setGeneration(this.generation);
        candidate.setID(this.rtpCandidateID);
        candidate.setIP(socket.getLocalAddress().getHostAddress());
        candidate.setPort(socket.getLocalPort());
        candidate.setType(CandidateType.host);
        pe.addCandidate(candidate);
        socket = streamConnector.getControlSocket();
        candidate = new CandidatePacketExtension();
        candidate.setComponent(2);
        candidate.setGeneration(this.generation);
        candidate.setID(this.rtcpCandidateID);
        candidate.setIP(socket.getLocalAddress().getHostAddress());
        candidate.setPort(socket.getLocalPort());
        candidate.setType(CandidateType.host);
        pe.addCandidate(candidate);
    }

    public StreamConnector getStreamConnector() {
        return this.streamConnector;
    }

    public MediaStreamTarget getStreamTarget() {
        return null;
    }

    public String getXmlNamespace() {
        return "urn:xmpp:jingle:transports:raw-udp:1";
    }

    public boolean startConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
        return false;
    }

    public void wrapupConnectivityEstablishment() {
    }
}

