/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactResourceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.MessageJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification.MailThreadInfo;
import net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification.MailboxIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification.MailboxIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification.MailboxQueryIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification.NewMailNotificationIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.mailnotification.NewMailNotificationProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.messagecorrection.MessageCorrectionExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.messagecorrection.MessageCorrectionExtensionProvider;
import net.java.sip.communicator.service.protocol.AbstractOperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationSetMessageCorrection;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Html2Text;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.MessageEventManager;
import org.jivesoftware.smackx.XHTMLManager;
import org.jivesoftware.smackx.packet.DelayInfo;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.MessageEvent;
import org.jivesoftware.smackx.packet.XHTMLExtension;

public class OperationSetBasicInstantMessagingJabberImpl
extends AbstractOperationSetBasicInstantMessaging
implements OperationSetMessageCorrection {
    private static final Logger logger = Logger.getLogger(OperationSetBasicInstantMessagingJabberImpl.class);
    private static final String PNAME_MAX_GMAIL_THREADS_PER_NOTIFICATION = "net.java.sip.communicator.impl.protocol.jabber.MAX_GMAIL_THREADS_PER_NOTIFICATION";
    private Map<String, TargetAddress> jids = new Hashtable<String, TargetAddress>();
    private SmackMessageListener smackMessageListener = null;
    private static final long JID_INACTIVITY_TIMEOUT = 600000L;
    private long lastReceivedMailboxResultTime = -1L;
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private static final String OPEN_BODY_TAG = "<body>";
    private static final String CLOSE_BODY_TAG = "</body>";
    private static final String HTML_NAMESPACE = "http://jabber.org/protocol/xhtml-im";
    private List<PacketFilter> packetFilters = new ArrayList<PacketFilter>();

    OperationSetBasicInstantMessagingJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.jabberProvider = provider;
        this.packetFilters.add(new GroupMessagePacketFilter());
        this.packetFilters.add((PacketFilter)new PacketTypeFilter(Message.class));
        provider.addRegistrationStateChangeListener(new RegistrationStateListener());
        ProviderManager man = ProviderManager.getInstance();
        MessageCorrectionExtensionProvider extProvider = new MessageCorrectionExtensionProvider();
        man.addExtensionProvider("replace", "urn:xmpp:message-correct:0", (Object)extProvider);
    }

    public net.java.sip.communicator.service.protocol.Message createMessage(String content, String contentType) {
        return this.createMessage(content, contentType, "UTF-8", null);
    }

    public net.java.sip.communicator.service.protocol.Message createMessage(String content, String contentType, String encoding, String subject) {
        return new MessageJabberImpl(content, contentType, encoding, subject);
    }

    net.java.sip.communicator.service.protocol.Message createMessage(String content, String contentType, String messageUID) {
        return new MessageJabberImpl(content, contentType, "UTF-8", null, messageUID);
    }

    public boolean isOfflineMessagingSupported() {
        return true;
    }

    public boolean isContentTypeSupported(String contentType) {
        return contentType.equals("text/plain") || contentType.equals("text/html");
    }

    public boolean isContentTypeSupported(String contentType, Contact contact) {
        if (contentType.equals("text/plain")) {
            return true;
        }
        if (contentType.equals("text/html")) {
            String toJID = this.getJidForAddress(contact.getAddress());
            if (toJID == null) {
                toJID = contact.getAddress();
            }
            return this.jabberProvider.isFeatureListSupported(toJID, HTML_NAMESPACE);
        }
        return false;
    }

    public Chat obtainChatInstance(String jid) {
        XMPPConnection jabberConnection = this.jabberProvider.getConnection();
        Chat chat = jabberConnection.getChatManager().getThreadChat(jid);
        if (chat != null) {
            return chat;
        }
        MessageListener msgListener = new MessageListener(){

            public void processMessage(Chat chat, Message message) {
            }
        };
        chat = jabberConnection.getChatManager().createChat(jid, msgListener);
        return chat;
    }

    private void purgeOldJids() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, TargetAddress>> entries = this.jids.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, TargetAddress> entry = entries.next();
            TargetAddress target = entry.getValue();
            if (currentTime - target.lastUpdatedTime <= 600000L) continue;
            entries.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJidForAddress(String address) {
        Map<String, TargetAddress> map = this.jids;
        synchronized (map) {
            this.purgeOldJids();
            TargetAddress ta = this.jids.get(address);
            if (ta == null) {
                return null;
            }
            ta.lastUpdatedTime = System.currentTimeMillis();
            return ta.jid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putJidForAddress(String address, String jid) {
        Map<String, TargetAddress> map = this.jids;
        synchronized (map) {
            this.purgeOldJids();
            TargetAddress ta = this.jids.get(address);
            if (ta == null) {
                ta = new TargetAddress();
                this.jids.put(address, ta);
            }
            ta.jid = jid;
            ta.lastUpdatedTime = System.currentTimeMillis();
        }
    }

    private MessageDeliveredEvent sendMessage(Contact to, ContactResource toResource, net.java.sip.communicator.service.protocol.Message message, PacketExtension[] extensions) {
        if (!(to instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not a Jabber contact." + to);
        }
        try {
            this.assertConnected();
            Message msg = new Message();
            String toJID = null;
            if (toResource != null) {
                String string = toJID = toResource.equals(ContactResource.BASE_RESOURCE) ? to.getAddress() : ((ContactResourceJabberImpl)toResource).getFullJid();
            }
            if (toJID == null) {
                toJID = this.getJidForAddress(to.getAddress());
            }
            if (toJID == null) {
                toJID = to.getAddress();
            }
            Chat chat = this.obtainChatInstance(toJID);
            msg.setPacketID(message.getMessageUID());
            msg.setTo(toJID);
            for (PacketExtension ext : extensions) {
                msg.addExtension(ext);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Will send a message to:" + toJID + " chat.jid=" + chat.getParticipant() + " chat.tid=" + chat.getThreadID()));
            }
            MessageDeliveredEvent msgDeliveryPendingEvt = new MessageDeliveredEvent(message, to);
            if ((msgDeliveryPendingEvt = this.messageDeliveryPendingTransform(msgDeliveryPendingEvt)) == null) {
                return null;
            }
            String content = msgDeliveryPendingEvt.getSourceMessage().getContent();
            if (message.getContentType().equals("text/html")) {
                msg.setBody(Html2Text.extractText((String)content));
                if (this.jabberProvider.isFeatureListSupported(chat.getParticipant(), HTML_NAMESPACE)) {
                    XHTMLManager.addBody((Message)msg, (String)(OPEN_BODY_TAG + content + CLOSE_BODY_TAG));
                }
            } else {
                msg.setBody(content);
            }
            MessageEventManager.addNotificationsRequests((Message)msg, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
            chat.sendMessage(msg);
            MessageDeliveredEvent msgDeliveredEvt = new MessageDeliveredEvent(message, to);
            return msgDeliveredEvt;
        }
        catch (XMPPException ex) {
            logger.error((Object)"message not sent", (Throwable)ex);
            return null;
        }
    }

    public void sendInstantMessage(Contact to, net.java.sip.communicator.service.protocol.Message message) throws IllegalStateException, IllegalArgumentException {
        this.sendInstantMessage(to, null, message);
    }

    public void sendInstantMessage(Contact to, ContactResource toResource, net.java.sip.communicator.service.protocol.Message message) throws IllegalStateException, IllegalArgumentException {
        MessageDeliveredEvent msgDelivered = this.sendMessage(to, toResource, message, new PacketExtension[0]);
        this.fireMessageEvent((EventObject)msgDelivered);
    }

    public void correctMessage(Contact to, net.java.sip.communicator.service.protocol.Message message, String correctedMessageUID) {
        PacketExtension[] exts = new PacketExtension[]{new MessageCorrectionExtension(correctedMessageUID)};
        MessageDeliveredEvent msgDelivered = this.sendMessage(to, null, message, exts);
        msgDelivered.setCorrectedMessageUID(correctedMessageUID);
        this.fireMessageEvent((EventObject)msgDelivered);
    }

    private void assertConnected() throws IllegalStateException {
        if (this.opSetPersPresence == null) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
        this.opSetPersPresence.assertConnected();
    }

    private void subscribeForGmailNotifications() {
        String accountIDService = this.jabberProvider.getAccountID().getService();
        boolean notificationsAreSupported = this.jabberProvider.isFeatureSupported(accountIDService, "google:mail:notify");
        if (!notificationsAreSupported) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(accountIDService + " does not seem to provide a Gmail notification " + " service so we won't be trying to subscribe for it"));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(accountIDService + " seems to provide a Gmail notification " + " service so we will try to subscribe for it"));
        }
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addIQProvider("mailbox", "google:mail:notify", (Object)new MailboxIQProvider());
        providerManager.addIQProvider("new-mail", "google:mail:notify", (Object)new NewMailNotificationProvider());
        XMPPConnection connection = this.jabberProvider.getConnection();
        connection.addPacketListener((PacketListener)new MailboxIQListener(), (PacketFilter)new PacketTypeFilter(MailboxIQ.class));
        connection.addPacketListener((PacketListener)new NewMailNotificationListener(), (PacketFilter)new PacketTypeFilter(NewMailNotificationIQ.class));
        if (this.opSetPersPresence.getCurrentStatusMessage().equals("Offline")) {
            return;
        }
        MailboxQueryIQ mailboxQuery = new MailboxQueryIQ();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("sending mailNotification for acc: " + this.jabberProvider.getAccountID().getAccountUniqueID()));
        }
        this.jabberProvider.getConnection().sendPacket((Packet)mailboxQuery);
    }

    private String createMailboxDescription(MailboxIQ mailboxIQ) {
        int maxThreads;
        Iterator<MailThreadInfo> threads;
        StringBuffer message;
        String resourceFooterKey;
        int threadCount;
        block5: {
            threadCount = mailboxIQ.getThreadCount();
            String resourceHeaderKey = threadCount > 1 ? "service.gui.NEW_GMAIL_MANY_HEADER" : "service.gui.NEW_GMAIL_HEADER";
            resourceFooterKey = threadCount > 1 ? "service.gui.NEW_GMAIL_MANY_FOOTER" : "service.gui.NEW_GMAIL_FOOTER";
            String newMailHeader = JabberActivator.getResources().getI18NString(resourceHeaderKey, new String[]{this.jabberProvider.getAccountID().getService(), mailboxIQ.getUrl(), Integer.toString(threadCount)});
            message = new StringBuffer(newMailHeader);
            message.append("<table width=100% cellpadding=2 cellspacing=0 ");
            message.append("border=0 bgcolor=#e8eef7>");
            threads = mailboxIQ.threads();
            String maxThreadsStr = (String)JabberActivator.getConfigurationService().getProperty(PNAME_MAX_GMAIL_THREADS_PER_NOTIFICATION);
            maxThreads = 5;
            try {
                if (maxThreadsStr != null) {
                    maxThreads = Integer.parseInt(maxThreadsStr);
                }
            }
            catch (NumberFormatException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)("Failed to parse max threads count: " + maxThreads + ". Going for default."));
            }
        }
        for (int i = 0; i < maxThreads && threads.hasNext(); ++i) {
            message.append(threads.next().createHtmlDescription());
        }
        message.append("</table><br/>");
        if (threadCount > maxThreads) {
            String messageFooter = JabberActivator.getResources().getI18NString(resourceFooterKey, new String[]{mailboxIQ.getUrl(), Integer.toString(threadCount - maxThreads)});
            message.append(messageFooter);
        }
        return message.toString();
    }

    public long getInactivityTimeout() {
        return 600000L;
    }

    public void addMessageFilters(PacketFilter filter) {
        this.packetFilters.add(filter);
    }

    private class NewMailNotificationListener
    implements PacketListener {
        private NewMailNotificationListener() {
        }

        public void processPacket(Packet packet) {
            if (packet != null && !(packet instanceof NewMailNotificationIQ)) {
                return;
            }
            boolean enableGmailNotifications = OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getAccountID().getAccountPropertyBoolean((Object)"GMAIL_NOTIFICATIONS_ENABLED", false);
            if (!enableGmailNotifications) {
                return;
            }
            if (OperationSetBasicInstantMessagingJabberImpl.this.opSetPersPresence.getCurrentStatusMessage().equals("Offline")) {
                return;
            }
            MailboxQueryIQ mailboxQueryIQ = new MailboxQueryIQ();
            if (OperationSetBasicInstantMessagingJabberImpl.this.lastReceivedMailboxResultTime != -1L) {
                mailboxQueryIQ.setNewerThanTime(OperationSetBasicInstantMessagingJabberImpl.this.lastReceivedMailboxResultTime);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("send mailNotification for acc: " + OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getAccountID().getAccountUniqueID()));
            }
            OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getConnection().sendPacket((Packet)mailboxQueryIQ);
        }
    }

    private class MailboxIQListener
    implements PacketListener {
        private MailboxIQListener() {
        }

        public void processPacket(Packet packet) {
            if (packet != null && !(packet instanceof MailboxIQ)) {
                return;
            }
            MailboxIQ mailboxIQ = (MailboxIQ)packet;
            if (mailboxIQ.getTotalMatched() < 1) {
                return;
            }
            Object sourceContact = OperationSetBasicInstantMessagingJabberImpl.this.opSetPersPresence.findContactByID(OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getAccountID().getService());
            if (sourceContact == null) {
                sourceContact = OperationSetBasicInstantMessagingJabberImpl.this.opSetPersPresence.createVolatileContact(OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getAccountID().getService());
            }
            OperationSetBasicInstantMessagingJabberImpl.this.lastReceivedMailboxResultTime = mailboxIQ.getResultTime();
            String newMail = OperationSetBasicInstantMessagingJabberImpl.this.createMailboxDescription(mailboxIQ);
            MessageJabberImpl newMailMessage = new MessageJabberImpl(newMail, "text/html", "UTF-8", null);
            MessageReceivedEvent msgReceivedEvt = new MessageReceivedEvent((net.java.sip.communicator.service.protocol.Message)newMailMessage, sourceContact, new Date(), 2);
            OperationSetBasicInstantMessagingJabberImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
        }
    }

    private static class GroupMessagePacketFilter
    implements PacketFilter {
        private GroupMessagePacketFilter() {
        }

        public boolean accept(Packet packet) {
            if (!(packet instanceof Message)) {
                return false;
            }
            Message msg = (Message)packet;
            return !msg.getType().equals((Object)Message.Type.groupchat);
        }
    }

    private class SmackMessageListener
    implements PacketListener {
        private SmackMessageListener() {
        }

        public void processPacket(Packet packet) {
            ContactResource resource;
            MessageReceivedEvent msgReceivedEvt;
            if (!(packet instanceof Message)) {
                return;
            }
            Message msg = (Message)packet;
            if (msg.getBody() == null) {
                return;
            }
            PacketExtension multiChatExtension = msg.getExtension("x", "http://jabber.org/protocol/muc#user");
            if (multiChatExtension != null) {
                return;
            }
            String fromUserID = StringUtils.parseBareAddress((String)msg.getFrom());
            boolean isPrivateMessaging = false;
            ChatRoomJabberImpl privateContactRoom = ((OperationSetMultiUserChatJabberImpl)OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getOperationSet(OperationSetMultiUserChat.class)).getChatRoom(fromUserID);
            if (privateContactRoom != null) {
                isPrivateMessaging = true;
            }
            if (logger.isDebugEnabled() && logger.isDebugEnabled()) {
                logger.debug((Object)("Received from " + fromUserID + " the message " + msg.toXML()));
            }
            net.java.sip.communicator.service.protocol.Message newMessage = OperationSetBasicInstantMessagingJabberImpl.this.createMessage(msg.getBody(), "text/plain", msg.getPacketID());
            PacketExtension ext = msg.getExtension(OperationSetBasicInstantMessagingJabberImpl.HTML_NAMESPACE);
            if (ext != null) {
                XHTMLExtension xhtmlExt = (XHTMLExtension)ext;
                Iterator bodies = xhtmlExt.getBodies();
                StringBuffer messageBuff = new StringBuffer();
                while (bodies.hasNext()) {
                    String body = (String)bodies.next();
                    messageBuff.append(body);
                }
                if (messageBuff.length() > 0) {
                    String receivedMessage = messageBuff.toString().replaceAll("\\<[bB][oO][dD][yY].*?>", "").replaceAll("\\</[bB][oO][dD][yY].*?>", "");
                    receivedMessage = receivedMessage.replaceAll("&apos;", "&#39;");
                    newMessage = OperationSetBasicInstantMessagingJabberImpl.this.createMessage(receivedMessage, "text/html", msg.getPacketID());
                }
            }
            PacketExtension correctionExtension = msg.getExtension("urn:xmpp:message-correct:0");
            String correctedMessageUID = null;
            if (correctionExtension != null) {
                correctedMessageUID = ((MessageCorrectionExtension)correctionExtension).getCorrectedMessageUID();
            }
            Object sourceContact = OperationSetBasicInstantMessagingJabberImpl.this.opSetPersPresence.findContactByID(isPrivateMessaging ? msg.getFrom() : fromUserID);
            if (msg.getType() == Message.Type.error) {
                MessageDeliveryFailedEvent ev;
                MessageEvent msgEvent;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Message error received from " + fromUserID));
                }
                int errorCode = packet.getError().getCode();
                int errorResultCode = 1;
                if (errorCode == 503 && (msgEvent = (MessageEvent)packet.getExtension("x", "jabber:x:event")) != null && msgEvent.isOffline()) {
                    errorResultCode = 5;
                }
                if ((ev = new MessageDeliveryFailedEvent(newMessage, sourceContact, correctedMessageUID, errorResultCode)) != null) {
                    OperationSetBasicInstantMessagingJabberImpl.this.fireMessageEvent((EventObject)ev);
                }
                return;
            }
            String address = fromUserID;
            if (isPrivateMessaging) {
                address = JabberActivator.getResources().getI18NString("service.gui.FROM", new String[]{StringUtils.parseResource((String)msg.getFrom()), fromUserID});
            }
            OperationSetBasicInstantMessagingJabberImpl.this.putJidForAddress(address, msg.getFrom());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("just mapped: " + fromUserID + " to " + msg.getFrom()));
            }
            if (sourceContact == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("received a message from an unknown contact: " + fromUserID));
                }
                sourceContact = OperationSetBasicInstantMessagingJabberImpl.this.opSetPersPresence.createVolatileContact(msg.getFrom(), isPrivateMessaging);
            }
            Date timestamp = new Date();
            PacketExtension delay = msg.getExtension("x", "jabber:x:delay");
            if (delay != null && delay instanceof DelayInformation) {
                timestamp = ((DelayInformation)delay).getStamp();
            }
            if ((delay = msg.getExtension("delay", "urn:xmpp:delay")) != null && delay instanceof DelayInfo) {
                timestamp = ((DelayInfo)delay).getStamp();
            }
            if ((msgReceivedEvt = new MessageReceivedEvent(newMessage, sourceContact, resource = ((ContactJabberImpl)((Object)sourceContact)).getResourceFromJid(msg.getFrom()), timestamp, correctedMessageUID, isPrivateMessaging, (ChatRoom)privateContactRoom)) != null) {
                OperationSetBasicInstantMessagingJabberImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
            }
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERING) {
                OperationSetBasicInstantMessagingJabberImpl.this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getOperationSet(OperationSetPersistentPresence.class);
                if (OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener == null) {
                    OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener = new SmackMessageListener();
                } else {
                    OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getConnection().removePacketListener((PacketListener)OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener);
                }
                OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getConnection().addPacketListener((PacketListener)OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener, (PacketFilter)new AndFilter(OperationSetBasicInstantMessagingJabberImpl.this.packetFilters.toArray(new PacketFilter[OperationSetBasicInstantMessagingJabberImpl.this.packetFilters.size()])));
            } else if (evt.getNewState() == RegistrationState.REGISTERED) {
                boolean enableGmailNotifications = OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getAccountID().getAccountPropertyBoolean((Object)"GMAIL_NOTIFICATIONS_ENABLED", false);
                if (enableGmailNotifications) {
                    OperationSetBasicInstantMessagingJabberImpl.this.subscribeForGmailNotifications();
                }
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.CONNECTION_FAILED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED) {
                if (OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getConnection() != null && OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener != null) {
                    OperationSetBasicInstantMessagingJabberImpl.this.jabberProvider.getConnection().removePacketListener((PacketListener)OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener);
                }
                OperationSetBasicInstantMessagingJabberImpl.this.smackMessageListener = null;
            }
        }
    }

    private class TargetAddress {
        String jid;
        long lastUpdatedTime;

        private TargetAddress() {
        }
    }
}

