/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.account;

import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.event.AccountManagerEvent;
import net.java.sip.communicator.service.protocol.event.AccountManagerListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.UtilActivator;
import net.java.sip.communicator.util.account.AccountStatusUtils;
import net.java.sip.communicator.util.account.LoginRenderer;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class LoginManager
implements ServiceListener,
RegistrationStateChangeListener,
AccountManagerListener {
    private static final Logger logger = Logger.getLogger(LoginManager.class);
    private boolean manuallyDisconnected = false;
    private final LoginRenderer loginRenderer;

    public LoginManager(LoginRenderer loginRenderer) {
        this.loginRenderer = loginRenderer;
        UtilActivator.bundleContext.addServiceListener((ServiceListener)this);
    }

    public void login(ProtocolProviderService protocolProvider) {
        this.loginRenderer.startConnectingUI(protocolProvider);
        new RegisterProvider(protocolProvider, this.loginRenderer.getSecurityAuthorityImpl(protocolProvider)).start();
    }

    public static void logoff(ProtocolProviderService protocolProvider) {
        new UnregisterProvider(protocolProvider).start();
    }

    public void runLogin() {
        UtilActivator.getAccountManager().addListener((AccountManagerListener)this);
        for (ProtocolProviderFactory providerFactory : UtilActivator.getProtocolProviderFactories().values()) {
            this.addAccountsForProtocolProviderFactory(providerFactory);
        }
    }

    public void handleAccountManagerEvent(AccountManagerEvent event) {
        if (event.getType() == 1) {
            this.addAccountsForProtocolProviderFactory(event.getFactory());
        }
    }

    private void addAccountsForProtocolProviderFactory(ProtocolProviderFactory providerFactory) {
        for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
            Object status;
            ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
            ProtocolProviderService protocolProvider = (ProtocolProviderService)UtilActivator.bundleContext.getService(serRef);
            if (!this.loginRenderer.containsProtocolProviderUI(protocolProvider)) {
                protocolProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
                this.loginRenderer.addProtocolProviderUI(protocolProvider);
            }
            if ((status = AccountStatusUtils.getProtocolProviderLastStatus(protocolProvider)) != null && !status.equals("Online") && (!(status instanceof PresenceStatus) || ((PresenceStatus)status).getStatus() < 20)) continue;
            this.login(protocolProvider);
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        RegistrationState newState = evt.getNewState();
        ProtocolProviderService protocolProvider = evt.getProvider();
        AccountID accountID = protocolProvider.getAccountID();
        if (logger.isTraceEnabled()) {
            logger.trace("Protocol provider: " + protocolProvider + " changed its state to: " + evt.getNewState().getStateName());
        }
        if (newState.equals((Object)RegistrationState.REGISTERED) || newState.equals((Object)RegistrationState.UNREGISTERED) || newState.equals((Object)RegistrationState.EXPIRED) || newState.equals((Object)RegistrationState.AUTHENTICATION_FAILED) || newState.equals((Object)RegistrationState.CONNECTION_FAILED) || newState.equals((Object)RegistrationState.CHALLENGED_FOR_AUTHENTICATION) || newState.equals((Object)RegistrationState.REGISTERED)) {
            this.loginRenderer.stopConnectingUI(protocolProvider);
        }
        if (newState.equals((Object)RegistrationState.REGISTERED)) {
            this.loginRenderer.protocolProviderConnected(protocolProvider, System.currentTimeMillis());
        } else if (newState.equals((Object)RegistrationState.AUTHENTICATION_FAILED)) {
            switch (evt.getReasonCode()) {
                case 5: {
                    String msgText = UtilActivator.getResources().getI18NString("service.gui.RECONNECTION_LIMIT_EXCEEDED", new String[]{accountID.getUserID(), accountID.getService()});
                    UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), msgText);
                    break;
                }
                case 3: {
                    String msgText = UtilActivator.getResources().getI18NString("service.gui.NON_EXISTING_USER_ID", new String[]{protocolProvider.getProtocolDisplayName()});
                    UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), msgText);
                    break;
                }
                case 9: {
                    String msgText = UtilActivator.getResources().getI18NString("service.gui.NON_SECURE_CONNECTION", new String[]{accountID.getAccountAddress()});
                    UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), msgText);
                    break;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace(evt.getReason());
            }
        } else if (newState.equals((Object)RegistrationState.EXPIRED)) {
            String msgText = UtilActivator.getResources().getI18NString("service.gui.CONNECTION_EXPIRED_MSG", new String[]{protocolProvider.getProtocolDisplayName()});
            UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), msgText);
            logger.error(evt.getReason());
        } else if (newState.equals((Object)RegistrationState.UNREGISTERED) && !this.manuallyDisconnected) {
            if (evt.getReasonCode() == 2) {
                String msgText = UtilActivator.getResources().getI18NString("service.gui.MULTIPLE_LOGINS", new String[]{accountID.getUserID(), accountID.getService()});
                UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), msgText);
            } else if (evt.getReasonCode() == 4) {
                String msgText = UtilActivator.getResources().getI18NString("service.gui.LIMIT_REACHED_FOR_IP", new String[]{protocolProvider.getProtocolDisplayName()});
                UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), msgText);
            } else if (evt.getReasonCode() != 0) {
                String msgText = UtilActivator.getResources().getI18NString("service.gui.UNREGISTERED_MESSAGE", new String[]{accountID.getUserID(), accountID.getService()});
                UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), msgText);
            }
            if (logger.isTraceEnabled()) {
                logger.trace(evt.getReason());
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object service = UtilActivator.bundleContext.getService(serviceRef);
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.handleProviderAdded((ProtocolProviderService)service);
                break;
            }
            case 4: {
                this.handleProviderRemoved((ProtocolProviderService)service);
            }
        }
    }

    private void handleProviderAdded(ProtocolProviderService protocolProvider) {
        if (logger.isTraceEnabled()) {
            logger.trace("The following protocol provider was just added: " + protocolProvider.getAccountID().getAccountAddress());
        }
        protocolProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        this.loginRenderer.addProtocolProviderUI(protocolProvider);
        Object status = AccountStatusUtils.getProtocolProviderLastStatus(protocolProvider);
        if (status == null || status.equals("Online") || status instanceof PresenceStatus && ((PresenceStatus)status).getStatus() >= 20) {
            this.login(protocolProvider);
        }
    }

    private void handleProviderRemoved(ProtocolProviderService protocolProvider) {
        this.loginRenderer.removeProtocolProviderUI(protocolProvider);
    }

    public boolean isManuallyDisconnected() {
        return this.manuallyDisconnected;
    }

    public void setManuallyDisconnected(boolean manuallyDisconnected) {
        this.manuallyDisconnected = manuallyDisconnected;
    }

    private static class UnregisterProvider
    extends Thread {
        ProtocolProviderService protocolProvider;

        UnregisterProvider(ProtocolProviderService protocolProvider) {
            this.protocolProvider = protocolProvider;
        }

        @Override
        public void run() {
            try {
                this.protocolProvider.unregister();
            }
            catch (OperationFailedException ex) {
                int errorCode = ex.getErrorCode();
                if (errorCode == 1) {
                    logger.error("Provider could not be unregistered due to the following general error: " + (Object)((Object)ex));
                } else if (errorCode == 4) {
                    logger.error("Provider could not be unregistered due to the following internal error: " + (Object)((Object)ex));
                } else if (errorCode == 2) {
                    logger.error("Provider could not be unregistered due to a network failure: " + (Object)((Object)ex));
                }
                UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), UtilActivator.getResources().getI18NString("service.gui.LOGOFF_NOT_SUCCEEDED", new String[]{this.protocolProvider.getAccountID().getUserID(), this.protocolProvider.getAccountID().getService()}));
            }
        }
    }

    private class RegisterProvider
    extends Thread {
        private final ProtocolProviderService protocolProvider;
        private final SecurityAuthority secAuth;

        RegisterProvider(ProtocolProviderService protocolProvider, SecurityAuthority secAuth) {
            this.protocolProvider = protocolProvider;
            this.secAuth = secAuth;
        }

        @Override
        public void run() {
            try {
                this.protocolProvider.register(this.secAuth);
            }
            catch (OperationFailedException ex) {
                this.handleOperationFailedException(ex);
            }
            catch (Throwable ex) {
                logger.error("Failed to register protocol provider. ", ex);
                AccountID accountID = this.protocolProvider.getAccountID();
                UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), UtilActivator.getResources().getI18NString("service.gui.LOGIN_GENERAL_ERROR", new String[]{accountID.getUserID(), accountID.getProtocolName(), accountID.getService()}));
            }
        }

        private void handleOperationFailedException(OperationFailedException ex) {
            String errorMessage = "";
            switch (ex.getErrorCode()) {
                case 1: {
                    logger.error("Provider could not be registered due to the following general error: ", ex);
                    AccountID accountID = this.protocolProvider.getAccountID();
                    errorMessage = UtilActivator.getResources().getI18NString("service.gui.LOGIN_GENERAL_ERROR", new String[]{accountID.getUserID(), accountID.getProtocolName(), accountID.getService()});
                    UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), errorMessage, (Throwable)ex);
                    break;
                }
                case 4: {
                    logger.error("Provider could not be registered due to the following internal error: ", ex);
                    AccountID accountID = this.protocolProvider.getAccountID();
                    errorMessage = UtilActivator.getResources().getI18NString("service.gui.LOGIN_INTERNAL_ERROR", new String[]{accountID.getUserID(), accountID.getService()});
                    UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), errorMessage, (Throwable)ex);
                    break;
                }
                case 2: {
                    if (logger.isInfoEnabled()) {
                        logger.info("Provider could not be registered due to a network failure: " + (Object)((Object)ex));
                    }
                    LoginManager.this.loginRenderer.protocolProviderConnectionFailed(this.protocolProvider, LoginManager.this);
                    break;
                }
                case 7: {
                    logger.error("Provider could not be registered due to an invalid account property: ", ex);
                    AccountID accountID = this.protocolProvider.getAccountID();
                    errorMessage = UtilActivator.getResources().getI18NString("service.gui.LOGIN_INVALID_PROPERTIES_ERROR", new String[]{accountID.getUserID(), accountID.getService()});
                    UtilActivator.getAlertUIService().showAlertDialog(UtilActivator.getResources().getI18NString("service.gui.ERROR"), errorMessage, (Throwable)ex);
                    break;
                }
                default: {
                    logger.error("Provider could not be registered.", ex);
                }
            }
        }
    }
}

