/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.AttributeSource;

public abstract class Tokenizer
extends TokenStream {
    protected Reader input;

    protected Tokenizer() {
    }

    protected Tokenizer(Reader input) {
        this.input = CharReader.get(input);
    }

    protected Tokenizer(AttributeSource.AttributeFactory factory) {
        super(factory);
    }

    protected Tokenizer(AttributeSource.AttributeFactory factory, Reader input) {
        super(factory);
        this.input = CharReader.get(input);
    }

    protected Tokenizer(AttributeSource source) {
        super(source);
    }

    protected Tokenizer(AttributeSource source, Reader input) {
        super(source);
        this.input = CharReader.get(input);
    }

    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
    }

    protected final int correctOffset(int currentOff) {
        return this.input instanceof CharStream ? ((CharStream)this.input).correctOffset(currentOff) : currentOff;
    }

    public void reset(Reader input) throws IOException {
        this.input = input;
    }
}

