/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.AbstractCall;
import net.java.sip.communicator.service.protocol.AbstractCallPeer;
import net.java.sip.communicator.service.protocol.AbstractConferenceMember;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.ConferenceInfoDocument;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.xml.XMLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractOperationSetTelephonyConferencing<ProtocolProviderServiceT extends ProtocolProviderService, OperationSetBasicTelephonyT extends OperationSetBasicTelephony<ProtocolProviderServiceT>, MediaAwareCallT extends MediaAwareCall<MediaAwareCallPeerT, OperationSetBasicTelephonyT, ProtocolProviderServiceT>, MediaAwareCallPeerT extends MediaAwareCallPeer<MediaAwareCallT, ?, ProtocolProviderServiceT>, CalleeAddressT>
implements OperationSetTelephonyConferencing,
RegistrationStateChangeListener,
PropertyChangeListener,
CallListener,
CallChangeListener {
    private static final Logger logger = Logger.getLogger(AbstractOperationSetTelephonyConferencing.class);
    protected static final String ELEMENT_DISPLAY_TEXT = "display-text";
    protected static final String ELEMENT_ENDPOINT = "endpoint";
    protected static final String ELEMENT_MEDIA = "media";
    protected static final String ELEMENT_SRC_ID = "src-id";
    protected static final String ELEMENT_STATUS = "status";
    protected static final String ELEMENT_TYPE = "type";
    protected static final String ELEMENT_USER = "user";
    protected static final String ELEMENT_USERS = "users";
    private static final String PARTIAL_NOTIFICATIONS_PROP_NAME = "RFC4575_PARTIAL_NOTIFICATIONS_ENABLED";
    private OperationSetBasicTelephonyT basicTelephony;
    private final CallPeerListener callPeerListener = new CallPeerAdapter(){

        @Override
        public void peerStateChanged(CallPeerChangeEvent evt) {
            CallPeerState state;
            Call call;
            CallPeer peer = evt.getSourceCallPeer();
            if (peer != null && (call = peer.getCall()) != null && (state = peer.getState()) != null && !state.equals(CallPeerState.DISCONNECTED) && !state.equals(CallPeerState.FAILED)) {
                AbstractOperationSetTelephonyConferencing.this.notifyAll(call);
            }
        }
    };
    protected final ProtocolProviderServiceT parentProvider;

    protected AbstractOperationSetTelephonyConferencing(ProtocolProviderServiceT parentProvider) {
        this.parentProvider = parentProvider;
        this.parentProvider.addRegistrationStateChangeListener(this);
    }

    protected void basicTelephonyChanged(OperationSetBasicTelephonyT oldValue, OperationSetBasicTelephonyT newValue) {
        if (oldValue != null) {
            oldValue.removeCallListener(this);
        }
        if (newValue != null) {
            newValue.addCallListener(this);
        }
    }

    protected void callBegun(CallEvent event) {
        Call call = event.getSourceCall();
        call.addCallChangeListener(this);
        Iterator<? extends CallPeer> callPeerIter = call.getCallPeers();
        while (callPeerIter.hasNext()) {
            this.callPeerAdded(new CallPeerEvent(callPeerIter.next(), call, 1));
        }
    }

    @Override
    public void callEnded(CallEvent event) {
        Call call = event.getSourceCall();
        Iterator<? extends CallPeer> callPeerIter = call.getCallPeers();
        while (callPeerIter.hasNext()) {
            this.callPeerRemoved(new CallPeerEvent(callPeerIter.next(), call, 2));
        }
        call.removeCallChangeListener(this);
    }

    @Override
    public void callPeerAdded(CallPeerEvent event) {
        MediaAwareCallPeer callPeer = (MediaAwareCallPeer)event.getSourceCallPeer();
        callPeer.addCallPeerListener(this.callPeerListener);
        callPeer.getMediaHandler().addPropertyChangeListener((PropertyChangeListener)this);
        this.callPeersChanged(event);
    }

    @Override
    public void callPeerRemoved(CallPeerEvent event) {
        MediaAwareCallPeer callPeer = (MediaAwareCallPeer)event.getSourceCallPeer();
        callPeer.removeCallPeerListener(this.callPeerListener);
        callPeer.getMediaHandler().removePropertyChangeListener((PropertyChangeListener)this);
        this.callPeersChanged(event);
    }

    private void callPeersChanged(CallPeerEvent event) {
        this.notifyAll(event.getSourceCall());
    }

    @Override
    public void callStateChanged(CallChangeEvent event) {
        if ("CallParticipantsChanged".equals(event.getPropertyName())) {
            this.notifyAll(event.getSourceCall());
        }
    }

    @Override
    public Call createConfCall(String[] callees) throws OperationFailedException {
        return this.createConfCall(callees, null);
    }

    @Override
    public Call createConfCall(String[] callees, CallConference conference) throws OperationFailedException {
        ArrayList<CalleeAddressT> calleeAddresses = new ArrayList<CalleeAddressT>(callees.length);
        for (String callee : callees) {
            calleeAddresses.add(this.parseAddressString(callee));
        }
        MediaAwareCallT call = this.createOutgoingCall();
        if (conference == null) {
            conference = ((MediaAwareCall)call).getConference();
        } else {
            ((MediaAwareCall)call).setConference(conference);
        }
        conference.setConferenceFocus(true);
        for (Object calleeAddress : calleeAddresses) {
            this.doInviteCalleeToCall(calleeAddress, call);
        }
        return call;
    }

    protected abstract MediaAwareCallT createOutgoingCall() throws OperationFailedException;

    protected abstract CallPeer doInviteCalleeToCall(CalleeAddressT var1, MediaAwareCallT var2) throws OperationFailedException;

    public OperationSetBasicTelephonyT getBasicTelephony() {
        return this.basicTelephony;
    }

    private void getEndpointMediaProperties(Node endpoint, Map<String, Object> properties) {
        NodeList endpointChildList = endpoint.getChildNodes();
        int endpoingChildCount = endpointChildList.getLength();
        for (int endpointChildIndex = 0; endpointChildIndex < endpoingChildCount; ++endpointChildIndex) {
            Node endpointChild = endpointChildList.item(endpointChildIndex);
            if (!ELEMENT_MEDIA.equals(endpointChild.getNodeName())) continue;
            NodeList mediaChildList = endpointChild.getChildNodes();
            int mediaChildCount = mediaChildList.getLength();
            String srcId = null;
            String status = null;
            String type = null;
            for (int mediaChildIndex = 0; mediaChildIndex < mediaChildCount; ++mediaChildIndex) {
                Node mediaChild = mediaChildList.item(mediaChildIndex);
                String mediaChildName = mediaChild.getNodeName();
                if (ELEMENT_SRC_ID.equals(mediaChildName)) {
                    srcId = mediaChild.getTextContent();
                    continue;
                }
                if (ELEMENT_STATUS.equals(mediaChildName)) {
                    status = mediaChild.getTextContent();
                    continue;
                }
                if (!ELEMENT_TYPE.equals(mediaChildName)) continue;
                type = mediaChild.getTextContent();
            }
            if (MediaType.AUDIO.toString().equalsIgnoreCase(type)) {
                properties.put("audioSsrc", srcId);
                properties.put("audioStatus", status);
                continue;
            }
            if (!MediaType.VIDEO.toString().equalsIgnoreCase(type)) continue;
            properties.put("videoSsrc", srcId);
            properties.put("videoStatus", status);
        }
    }

    private String getEndpointStatus(Node endpoint) {
        NodeList childNodes = endpoint.getChildNodes();
        int childCount = childNodes.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = childNodes.item(i);
            if (!ELEMENT_STATUS.equals(child.getNodeName())) continue;
            return child.getTextContent();
        }
        return null;
    }

    protected long getRemoteSourceID(MediaAwareCallPeer<?, ?, ?> callPeer, MediaType mediaType) {
        Call call;
        long remoteSourceID = ((CallPeerMediaHandler)((Object)callPeer.getMediaHandler())).getRemoteSSRC(mediaType);
        if (remoteSourceID != -1L && (call = callPeer.getCall()) != null) {
            for (MediaAwareCallPeer aCallPeer : ((AbstractCall)call).getCallPeerList()) {
                long aRemoteSourceID;
                if (aCallPeer == callPeer || (aRemoteSourceID = ((CallPeerMediaHandler)((Object)aCallPeer.getMediaHandler())).getRemoteSSRC(mediaType)) != remoteSourceID) continue;
                remoteSourceID = -1L;
                break;
            }
        }
        return remoteSourceID;
    }

    @Override
    public void incomingCallReceived(CallEvent event) {
        this.callBegun(event);
    }

    @Override
    public CallPeer inviteCalleeToCall(String uri, Call call) throws OperationFailedException {
        CalleeAddressT calleeAddress = this.parseAddressString(uri);
        MediaAwareCall mediaAwareCallT = (MediaAwareCall)call;
        mediaAwareCallT.getConference().setConferenceFocus(true);
        return this.doInviteCalleeToCall(calleeAddress, mediaAwareCallT);
    }

    protected void notifyAll(Call call) {
        CallConference conference = call.getConference();
        if (conference == null) {
            this.notifyCallPeers(call);
        } else {
            for (Call conferenceCall : conference.getCalls()) {
                OperationSetTelephonyConferencing opSet = conferenceCall.getProtocolProvider().getOperationSet(OperationSetTelephonyConferencing.class);
                if (!(opSet instanceof AbstractOperationSetTelephonyConferencing)) continue;
                ((AbstractOperationSetTelephonyConferencing)opSet).notifyCallPeers(conferenceCall);
            }
        }
    }

    protected abstract void notifyCallPeers(Call var1);

    @Override
    public void outgoingCallCreated(CallEvent event) {
        this.callBegun(event);
    }

    protected abstract CalleeAddressT parseAddressString(String var1) throws OperationFailedException;

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        CallPeerMediaHandler mediaHandler;
        Call call;
        String propertyName = ev.getPropertyName();
        if (("AUDIO_LOCAL_SSRC".equals(propertyName) || "AUDIO_REMOTE_SSRC".equals(propertyName) || "VIDEO_LOCAL_SSRC".equals(propertyName) || "VIDEO_REMOTE_SSRC".equals(propertyName)) && (call = ((MediaAwareCallPeer)(mediaHandler = (CallPeerMediaHandler)((Object)ev.getSource())).getPeer()).getCall()) != null) {
            this.notifyAll(call);
        }
    }

    @Override
    public void registrationStateChanged(RegistrationStateChangeEvent event) {
        RegistrationState newState = event.getNewState();
        if (RegistrationState.REGISTERED.equals(newState)) {
            OperationSetBasicTelephony basicTelephony = this.parentProvider.getOperationSet(OperationSetBasicTelephony.class);
            if (this.basicTelephony != basicTelephony) {
                OperationSetBasicTelephonyT oldValue = this.basicTelephony;
                this.basicTelephony = basicTelephony;
                this.basicTelephonyChanged(oldValue, this.basicTelephony);
            }
        } else if (RegistrationState.UNREGISTERED.equals(newState) && this.basicTelephony != null) {
            OperationSetBasicTelephonyT oldValue = this.basicTelephony;
            this.basicTelephony = null;
            this.basicTelephonyChanged(oldValue, null);
        }
    }

    private int setConferenceInfoDocument(MediaAwareCallPeerT callPeer, ConferenceInfoDocument confInfo) {
        NodeList usersList = confInfo.getDocument().getElementsByTagName(ELEMENT_USERS);
        ConferenceMember[] toRemove = ((AbstractCallPeer)callPeer).getConferenceMembers().toArray(AbstractCallPeer.NO_CONFERENCE_MEMBERS);
        int toRemoveCount = toRemove.length;
        boolean changed = false;
        if (usersList.getLength() > 0) {
            NodeList userList = usersList.item(0).getChildNodes();
            int userCount = userList.getLength();
            HashMap<String, Object> conferenceMemberProperties = new HashMap<String, Object>();
            for (int userIndex = 0; userIndex < userCount; ++userIndex) {
                boolean addConferenceMember;
                String address;
                Node user = userList.item(userIndex);
                if (!ELEMENT_USER.equals(user.getNodeName()) || (address = AbstractOperationSetTelephonyConferencing.stripParametersFromAddress(((Element)user).getAttribute("entity"))) == null || address.length() < 1) continue;
                AbstractConferenceMember conferenceMember = null;
                for (int i = 0; i < toRemoveCount; ++i) {
                    ConferenceMember aConferenceMember = toRemove[i];
                    if (aConferenceMember == null || !address.equalsIgnoreCase(aConferenceMember.getAddress())) continue;
                    toRemove[i] = null;
                    conferenceMember = (AbstractConferenceMember)aConferenceMember;
                    break;
                }
                if (conferenceMember == null) {
                    conferenceMember = new AbstractConferenceMember((CallPeer)callPeer, address);
                    addConferenceMember = true;
                } else {
                    addConferenceMember = false;
                }
                if (conferenceMember == null) continue;
                NodeList userChildList = user.getChildNodes();
                int userChildCount = userChildList.getLength();
                String displayName = null;
                String endpointStatus = null;
                conferenceMemberProperties.put("audioSsrc", null);
                conferenceMemberProperties.put("audioStatus", null);
                conferenceMemberProperties.put("videoSsrc", null);
                conferenceMemberProperties.put("videoStatus", null);
                for (int userChildIndex = 0; userChildIndex < userChildCount; ++userChildIndex) {
                    Node userChild = userChildList.item(userChildIndex);
                    String userChildName = userChild.getNodeName();
                    if (ELEMENT_DISPLAY_TEXT.equals(userChildName)) {
                        displayName = userChild.getTextContent();
                        continue;
                    }
                    if (!ELEMENT_ENDPOINT.equals(userChildName)) continue;
                    endpointStatus = this.getEndpointStatus(userChild);
                    this.getEndpointMediaProperties(userChild, conferenceMemberProperties);
                }
                conferenceMember.setDisplayName(displayName);
                conferenceMember.setEndpointStatus(endpointStatus);
                changed = conferenceMember.setProperties(conferenceMemberProperties);
                if (!addConferenceMember) continue;
                ((AbstractCallPeer)callPeer).addConferenceMember(conferenceMember);
            }
        }
        for (int i = 0; i < toRemoveCount; ++i) {
            ConferenceMember conferenceMemberToRemove = toRemove[i];
            if (conferenceMemberToRemove == null) continue;
            ((MediaAwareCallPeer)callPeer).removeConferenceMember(conferenceMemberToRemove);
        }
        if (changed) {
            this.notifyAll(((MediaAwareCallPeer)callPeer).getCall());
        }
        ((MediaAwareCallPeer)callPeer).setLastConferenceInfoReceived(confInfo);
        return confInfo.getVersion();
    }

    protected int setConferenceInfoXML(MediaAwareCallPeerT callPeer, String conferenceInfoXML) throws XMLException {
        ConferenceInfoDocument confInfo = new ConferenceInfoDocument(conferenceInfoXML);
        ((AbstractCallPeer)callPeer).setConferenceFocus(true);
        int documentVersion = confInfo.getVersion();
        int ourVersion = ((MediaAwareCallPeer)callPeer).getLastConferenceInfoReceivedVersion();
        ConferenceInfoDocument.State documentState = confInfo.getState();
        if (ourVersion == -1) {
            if (documentState == ConferenceInfoDocument.State.FULL) {
                return this.setConferenceInfoDocument(callPeer, confInfo);
            }
            logger.warn((Object)("Received a conference-info document with state '" + (Object)((Object)documentState) + "'. Cannot apply it, because we haven't " + "initialized a local document yet. Sending peer: " + callPeer));
            return -1;
        }
        if (documentVersion <= ourVersion) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Received a stale conference-info document. Local version " + ourVersion + ", document version " + documentVersion + ". Sending peer: " + callPeer));
            }
            return -1;
        }
        if (documentState == ConferenceInfoDocument.State.FULL) {
            return this.setConferenceInfoDocument(callPeer, confInfo);
        }
        if (documentState == ConferenceInfoDocument.State.DELETED) {
            logger.warn((Object)("Received a conference-info document with state'deleted', can't handle. Sending peer: " + callPeer));
            return -1;
        }
        if (documentState == ConferenceInfoDocument.State.PARTIAL) {
            if (documentVersion == ourVersion + 1) {
                return this.updateConferenceInfoDocument(callPeer, confInfo);
            }
            logger.warn((Object)("Received a Conference Information document with state '" + (Object)((Object)documentState) + "' and version " + documentVersion + ". Cannon apply it, because local " + "version is " + ourVersion + ". Sending peer: " + callPeer));
            return -1;
        }
        return -1;
    }

    public static String stripParametersFromAddress(String address) {
        int parametersBeginIndex;
        if (address != null && (parametersBeginIndex = address.indexOf(59)) > -1) {
            address = address.substring(0, parametersBeginIndex);
        }
        return address;
    }

    protected ConferenceInfoDocument getCurrentConferenceInfo(MediaAwareCallPeer<?, ?, ?> callPeer) {
        ConferenceInfoDocument confInfo;
        try {
            confInfo = new ConferenceInfoDocument();
        }
        catch (XMLException e) {
            return null;
        }
        confInfo.setState(ConferenceInfoDocument.State.FULL);
        confInfo.setEntity(this.getLocalEntity(callPeer));
        Call call = callPeer.getCall();
        if (call == null) {
            return null;
        }
        List<CallPeer> conferenceCallPeers = CallConference.getCallPeers(call);
        confInfo.setUserCount(1 + conferenceCallPeers.size());
        this.addPeerToConferenceInfo(confInfo, callPeer, false);
        for (CallPeer conferenceCallPeer : conferenceCallPeers) {
            if (!(conferenceCallPeer instanceof MediaAwareCallPeer)) continue;
            this.addPeerToConferenceInfo(confInfo, (MediaAwareCallPeer)conferenceCallPeer, true);
        }
        return confInfo;
    }

    private void addPeerToConferenceInfo(ConferenceInfoDocument confInfo, MediaAwareCallPeer<?, ?, ?> callPeer, boolean remote) {
        String entity = remote ? callPeer.getEntity() : this.getLocalEntity(callPeer);
        ConferenceInfoDocument.User user = confInfo.addNewUser(entity);
        String displayName = remote ? callPeer.getDisplayName() : this.getLocalDisplayName();
        user.setDisplayText(displayName);
        ConferenceInfoDocument.Endpoint endpoint = user.addNewEndpoint(entity);
        endpoint.setStatus(remote ? this.getEndpointStatus(callPeer) : ConferenceInfoDocument.EndpointStatusType.connected);
        Object mediaHandler = callPeer.getMediaHandler();
        for (MediaType mediaType : MediaType.values()) {
            MediaStream stream = ((CallPeerMediaHandler)((Object)mediaHandler)).getStream(mediaType);
            if (stream == null && remote) continue;
            long srcId = -1L;
            if (remote) {
                srcId = this.getRemoteSourceID(callPeer, mediaType);
            } else if (stream != null) {
                srcId = stream.getLocalSourceID();
            } else {
                for (MediaAwareCallPeer otherCallPeer : ((AbstractCall)callPeer.getCall()).getCallPeerList()) {
                    MediaStream otherStream = ((CallPeerMediaHandler)((Object)otherCallPeer.getMediaHandler())).getStream(mediaType);
                    if (otherStream == null) continue;
                    srcId = otherStream.getLocalSourceID();
                    break;
                }
            }
            MediaDirection direction = MediaDirection.INACTIVE;
            if (remote) {
                direction = callPeer.getDirection(mediaType).getReverseDirection();
            } else {
                if (mediaType == MediaType.AUDIO && ((CallPeerMediaHandler)((Object)callPeer.getMediaHandler())).isLocalAudioTransmissionEnabled()) {
                    direction = direction.or(MediaDirection.SENDONLY);
                } else if (mediaType == MediaType.VIDEO && callPeer.isLocalVideoStreaming()) {
                    direction = direction.or(MediaDirection.SENDONLY);
                }
                if (callPeer.getDirection(mediaType).allowsReceiving()) {
                    direction = direction.or(MediaDirection.RECVONLY);
                }
            }
            if (srcId == -1L && direction == MediaDirection.INACTIVE) continue;
            ConferenceInfoDocument.Media media = endpoint.addNewMedia(mediaType.toString());
            media.setType(mediaType.toString());
            if (srcId != -1L) {
                media.setSrcId(Long.toString(srcId));
            }
            media.setStatus(direction.toString());
        }
    }

    protected abstract String getLocalEntity(CallPeer var1);

    protected abstract String getLocalDisplayName();

    private ConferenceInfoDocument.EndpointStatusType getEndpointStatus(CallPeer callPeer) {
        CallPeerState callPeerState = callPeer.getState();
        if (CallPeerState.ALERTING_REMOTE_SIDE.equals(callPeerState)) {
            return ConferenceInfoDocument.EndpointStatusType.alerting;
        }
        if (CallPeerState.CONNECTING.equals(callPeerState) || CallPeerState.CONNECTING_WITH_EARLY_MEDIA.equals(callPeerState)) {
            return ConferenceInfoDocument.EndpointStatusType.pending;
        }
        if (CallPeerState.DISCONNECTED.equals(callPeerState)) {
            return ConferenceInfoDocument.EndpointStatusType.disconnected;
        }
        if (CallPeerState.INCOMING_CALL.equals(callPeerState)) {
            return ConferenceInfoDocument.EndpointStatusType.dialing_in;
        }
        if (CallPeerState.INITIATING_CALL.equals(callPeerState)) {
            return ConferenceInfoDocument.EndpointStatusType.dialing_out;
        }
        if (CallPeerState.ON_HOLD_REMOTELY.equals(callPeerState)) {
            return ConferenceInfoDocument.EndpointStatusType.on_hold;
        }
        if (CallPeerState.ON_HOLD_LOCALLY.equals(callPeerState) || CallPeerState.ON_HOLD_MUTUALLY.equals(callPeerState)) {
            return ConferenceInfoDocument.EndpointStatusType.on_hold;
        }
        if (CallPeerState.CONNECTED.equals(callPeerState)) {
            return ConferenceInfoDocument.EndpointStatusType.connected;
        }
        return null;
    }

    protected ConferenceInfoDocument getConferenceInfoDiff(ConferenceInfoDocument from, ConferenceInfoDocument to) throws IllegalArgumentException {
        ConferenceInfoDocument diff;
        if (from.getState() != ConferenceInfoDocument.State.FULL) {
            throw new IllegalArgumentException("The 'from' document needs to have state=full");
        }
        if (to.getState() != ConferenceInfoDocument.State.FULL) {
            throw new IllegalArgumentException("The 'to' document needs to have state=full");
        }
        if (!this.isPartialNotificationEnabled()) {
            return this.conferenceInfoDocumentsMatch(from, to) ? null : to;
        }
        try {
            diff = new ConferenceInfoDocument();
        }
        catch (XMLException e) {
            return this.conferenceInfoDocumentsMatch(from, to) ? null : to;
        }
        diff.setState(ConferenceInfoDocument.State.PARTIAL);
        diff.setUsersState(ConferenceInfoDocument.State.PARTIAL);
        String sid = to.getSid();
        if (sid != null && !sid.equals("")) {
            diff.setSid(to.getSid());
        }
        diff.setUserCount(to.getUserCount());
        diff.setEntity(to.getEntity());
        boolean needsPartial = false;
        boolean hasDifference = false;
        if (!from.getEntity().equals(to.getEntity()) || from.getUserCount() != to.getUserCount()) {
            hasDifference = true;
        }
        for (ConferenceInfoDocument.User user : from.getUsers()) {
            if (to.getUser(user.getEntity()) != null) continue;
            ConferenceInfoDocument.User deletedUser = diff.addNewUser(user.getEntity());
            deletedUser.setState(ConferenceInfoDocument.State.DELETED);
            hasDifference = true;
            needsPartial = true;
        }
        for (ConferenceInfoDocument.User toUser : to.getUsers()) {
            ConferenceInfoDocument.User fromUser;
            if (!this.usersMatch(toUser, fromUser = from.getUser(toUser.getEntity()))) {
                hasDifference = true;
                diff.addUser(toUser);
                continue;
            }
            needsPartial = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generated partial notification. From: " + from + "\nTo: " + to + "\nDiff: " + diff + "(hasDifference: " + hasDifference + ")"));
        }
        if (!hasDifference) {
            return null;
        }
        if (!needsPartial) {
            diff.setState(ConferenceInfoDocument.State.FULL);
            diff.setUsersState(ConferenceInfoDocument.State.FULL);
        }
        return diff;
    }

    private int updateConferenceInfoDocument(MediaAwareCallPeerT callPeer, ConferenceInfoDocument diff) {
        ConferenceInfoDocument newDocument;
        ConferenceInfoDocument ourDocument = ((MediaAwareCallPeer)callPeer).getLastConferenceInfoReceived();
        ConferenceInfoDocument.State usersState = diff.getUsersState();
        if (usersState == ConferenceInfoDocument.State.FULL) {
            try {
                newDocument = new ConferenceInfoDocument(diff);
            }
            catch (XMLException e) {
                logger.error((Object)"Could not create a new ConferenceInfoDocument");
                return -1;
            }
            newDocument.setState(ConferenceInfoDocument.State.FULL);
        } else if (usersState == ConferenceInfoDocument.State.DELETED) {
            try {
                newDocument = new ConferenceInfoDocument();
            }
            catch (XMLException e) {
                logger.error((Object)"Could not create a new ConferenceInfoDocument", (Throwable)e);
                return -1;
            }
            newDocument.setVersion(diff.getVersion());
            newDocument.setEntity(diff.getEntity());
            newDocument.setUserCount(diff.getUserCount());
        } else {
            try {
                newDocument = new ConferenceInfoDocument(ourDocument);
            }
            catch (XMLException e) {
                logger.error((Object)"Could not create a new ConferenceInfoDocument", (Throwable)e);
                return -1;
            }
            newDocument.setVersion(diff.getVersion());
            newDocument.setEntity(diff.getEntity());
            newDocument.setUserCount(diff.getUserCount());
            for (ConferenceInfoDocument.User user : diff.getUsers()) {
                ConferenceInfoDocument.State userState = user.getState();
                if (userState == ConferenceInfoDocument.State.FULL) {
                    newDocument.removeUser(user.getEntity());
                    newDocument.addUser(user);
                    continue;
                }
                if (userState == ConferenceInfoDocument.State.DELETED) {
                    newDocument.removeUser(user.getEntity());
                    continue;
                }
                ConferenceInfoDocument.User ourUser = newDocument.getUser(user.getEntity());
                ourUser.setDisplayText(user.getDisplayText());
                for (ConferenceInfoDocument.Endpoint endpoint : user.getEndpoints()) {
                    ConferenceInfoDocument.State endpointState = endpoint.getState();
                    if (endpointState == ConferenceInfoDocument.State.FULL) {
                        ourUser.removeEndpoint(endpoint.getEntity());
                        ourUser.addEndpoint(endpoint);
                        continue;
                    }
                    if (endpointState == ConferenceInfoDocument.State.DELETED) {
                        ourUser.removeEndpoint(endpoint.getEntity());
                        continue;
                    }
                    ConferenceInfoDocument.Endpoint ourEndpoint = ourUser.getEndpoint(endpoint.getEntity());
                    for (ConferenceInfoDocument.Media media : endpoint.getMedias()) {
                        ourEndpoint.removeMedia(media.getId());
                        ourEndpoint.addMedia(media);
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applied a partial conference-info notification.  Base: " + ourDocument + "\nDiff: " + diff + "\nResult:" + newDocument));
        }
        return this.setConferenceInfoDocument(callPeer, newDocument);
    }

    private boolean conferenceInfoDocumentsMatch(ConferenceInfoDocument a, ConferenceInfoDocument b) {
        if (a.getState() != ConferenceInfoDocument.State.FULL) {
            throw new IllegalArgumentException("The 'a' document needs tohave state=full");
        }
        if (b.getState() != ConferenceInfoDocument.State.FULL) {
            throw new IllegalArgumentException("The 'b' document needs tohave state=full");
        }
        if (!this.stringsMatch(a.getEntity(), b.getEntity())) {
            return false;
        }
        if (a.getUserCount() != b.getUserCount()) {
            return false;
        }
        if (a.getUsers().size() != b.getUsers().size()) {
            return false;
        }
        for (ConferenceInfoDocument.User aUser : a.getUsers()) {
            if (this.usersMatch(aUser, b.getUser(aUser.getEntity()))) continue;
            return false;
        }
        return true;
    }

    private boolean usersMatch(ConferenceInfoDocument.User a, ConferenceInfoDocument.User b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!this.stringsMatch(a.getEntity(), b.getEntity())) {
            return false;
        }
        if (!this.stringsMatch(a.getDisplayText(), b.getDisplayText())) {
            return false;
        }
        if (a.getEndpoints().size() != b.getEndpoints().size()) {
            return false;
        }
        for (ConferenceInfoDocument.Endpoint aEndpoint : a.getEndpoints()) {
            if (this.endpointsMatch(aEndpoint, b.getEndpoint(aEndpoint.getEntity()))) continue;
            return false;
        }
        return true;
    }

    private boolean endpointsMatch(ConferenceInfoDocument.Endpoint a, ConferenceInfoDocument.Endpoint b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!this.stringsMatch(a.getEntity(), b.getEntity())) {
            return false;
        }
        if (a.getStatus() != b.getStatus()) {
            return false;
        }
        if (a.getMedias().size() != b.getMedias().size()) {
            return false;
        }
        for (ConferenceInfoDocument.Media aMedia : a.getMedias()) {
            if (this.mediasMatch(aMedia, b.getMedia(aMedia.getId()))) continue;
            return false;
        }
        return true;
    }

    private boolean mediasMatch(ConferenceInfoDocument.Media a, ConferenceInfoDocument.Media b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!this.stringsMatch(a.getId(), b.getId())) {
            return false;
        }
        if (!this.stringsMatch(a.getSrcId(), b.getSrcId())) {
            return false;
        }
        if (!this.stringsMatch(a.getType(), b.getType())) {
            return false;
        }
        return this.stringsMatch(a.getStatus(), b.getStatus());
    }

    private boolean stringsMatch(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private boolean isPartialNotificationEnabled() {
        return Boolean.parseBoolean(this.parentProvider.getAccountID().getAccountProperties().get(PARTIAL_NOTIFICATIONS_PROP_NAME));
    }

    @Override
    public ConferenceDescription setupConference(ChatRoom chatRoom) {
        return null;
    }
}

