/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openymsg.network.ConnectionHandler;
import org.openymsg.network.NetworkConstants;
import org.openymsg.network.PacketBodyBuffer;
import org.openymsg.network.ServiceType;
import org.openymsg.network.Session;
import org.openymsg.network.SessionState;
import org.openymsg.network.Util;
import org.openymsg.network.YMSG9InputStream;
import org.openymsg.network.YMSG9Packet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPConnectionHandler
extends ConnectionHandler {
    private static final Log log = LogFactory.getLog(HTTPConnectionHandler.class);
    private static final long IDLE_TIMEOUT = 30000L;
    private static final String HTTP_HEADER_POST = "POST http://" + Util.httpHost() + "/notify HTTP/1.0" + "\n";
    private static final String HTTP_HEADER_AGENT = "User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)\n";
    private static final String HTTP_HEADER_HOST = "Host: " + Util.httpHost() + "\n";
    private static final String HTTP_HEADER_PROXY_AUTH = "Proxy-Authorization: " + Util.httpProxyAuth() + "\n";
    private Session session;
    private String proxyHost;
    private int proxyPort;
    private long lastFetch;
    private final Queue<YMSG9Packet> packets;
    private boolean connected = false;
    private String cookie = null;
    private long identifier = 0L;
    private Notifier notifierThread;

    public HTTPConnectionHandler() {
        this(Util.httpProxyHost(), Util.httpProxyPort());
    }

    public HTTPConnectionHandler(String proxyHost, int proxyPort, Collection<String> blacklist) {
        if (proxyHost == null || proxyHost.length() == 0 || proxyPort <= 0 || proxyPort > 65535) {
            throw new IllegalArgumentException("Bad HTTP proxy properties");
        }
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.packets = new LinkedList<YMSG9Packet>();
        this.connected = false;
        Properties p = System.getProperties();
        p.put("proxyHost", this.proxyHost);
        p.put("http.proxyHost", this.proxyHost);
        p.put("proxyPort", this.proxyPort + "");
        p.put("http.proxyPort", this.proxyPort + "");
        p.put("proxySet", "true");
        if (blacklist != null) {
            StringBuffer sb = new StringBuffer();
            for (String host : blacklist) {
                sb.append(host).append('|');
            }
            sb.setLength(sb.length() - 1);
            System.getProperties().put("http.nonProxyHosts", sb.toString());
        }
    }

    public HTTPConnectionHandler(String proxyHost, int proxyPort) {
        this(proxyHost, proxyPort, null);
    }

    public static void setProxyAuthorizationProperty(String method, String username, String password) throws UnsupportedOperationException {
        if (!method.equalsIgnoreCase("basic")) {
            throw new UnsupportedOperationException("Method " + method + " unsupported.");
        }
        String a = username + ":" + password;
        String s = "Basic " + Util.base64(a.getBytes());
        System.setProperty("openymsg.network.httpProxyAuth", s);
    }

    @Override
    void install(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void open() {
        this.connected = true;
        HTTPConnectionHandler hTTPConnectionHandler = this;
        synchronized (hTTPConnectionHandler) {
            if (this.notifierThread == null) {
                this.notifierThread = new Notifier("HTTP Notifier");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        this.connected = false;
        HTTPConnectionHandler hTTPConnectionHandler = this;
        synchronized (hTTPConnectionHandler) {
            if (this.notifierThread != null) {
                this.notifierThread.quitFlag = true;
                this.notifierThread = null;
            }
        }
    }

    @Override
    synchronized void sendPacket(PacketBodyBuffer body, ServiceType service, long status, long sessionID) throws IOException, IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("Not logged in");
        }
        if (this.filterOutput(body, service)) {
            return;
        }
        byte[] b = body.getBuffer();
        Socket soc = new Socket(this.proxyHost, this.proxyPort);
        PushbackInputStream pbis = new PushbackInputStream(soc.getInputStream());
        DataOutputStream dos = new DataOutputStream(soc.getOutputStream());
        dos.writeBytes(HTTP_HEADER_POST);
        dos.writeBytes("Content-length: " + (b.length + 20) + "\n");
        dos.writeBytes(HTTP_HEADER_AGENT);
        dos.writeBytes(HTTP_HEADER_HOST);
        if (HTTP_HEADER_PROXY_AUTH != null) {
            dos.writeBytes(HTTP_HEADER_PROXY_AUTH);
        }
        if (this.cookie != null) {
            dos.writeBytes("Cookie: " + this.cookie + "\n");
        }
        dos.writeBytes("\n");
        dos.write(NetworkConstants.MAGIC, 0, 4);
        dos.write(NetworkConstants.VERSION_HTTP, 0, 4);
        dos.writeShort(b.length & 0xFFFF);
        dos.writeShort(service.getValue() & 0xFFFF);
        dos.writeInt((int)(status & 0xFFFFFFFFFFFFFFFFL));
        dos.writeInt((int)(sessionID & 0xFFFFFFFFFFFFFFFFL));
        dos.write(b, 0, b.length);
        dos.flush();
        String s = this.readLine(pbis);
        if (s == null || s.indexOf(" 200 ") < 0) {
            throw new IOException("HTTP request returned didn't return OK (200): " + s);
        }
        while (s != null && s.trim().length() > 0) {
            s = this.readLine(pbis);
        }
        byte[] code = new byte[4];
        int res = pbis.read(code, 0, 4);
        if (res < 4) {
            throw new IOException("Premature end of HTTP data");
        }
        int count = code[0];
        YMSG9InputStream yip = new YMSG9InputStream(pbis);
        for (int i = 0; i < count; ++i) {
            YMSG9Packet pkt = yip.readPacket();
            if (this.filterInput(pkt) || this.packets.add(pkt)) continue;
            throw new IllegalArgumentException("Unable to add data to the packetQueue!");
        }
        soc.close();
        this.lastFetch = System.currentTimeMillis();
    }

    private String readLine(PushbackInputStream pbis) throws IOException {
        int c = pbis.read();
        StringBuffer sb = new StringBuffer();
        while (c != 10 && c != 13) {
            sb.append((char)c);
            c = pbis.read();
        }
        int c2 = pbis.read();
        if (c == 10 && c2 != 13 || c == 13 && c2 != 10) {
            pbis.unread(c2);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    YMSG9Packet receivePacket() throws IOException {
        if (!this.connected) {
            throw new IllegalStateException("Not logged in");
        }
        while (true) {
            HTTPConnectionHandler hTTPConnectionHandler = this;
            synchronized (hTTPConnectionHandler) {
                if (this.packets.size() > 0) {
                    YMSG9Packet o = this.packets.poll();
                    if (o instanceof IOException) {
                        throw (IOException)((Object)o);
                    }
                    return o;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private boolean filterOutput(PacketBodyBuffer body, ServiceType service) throws UnsupportedEncodingException, IOException {
        switch (service) {
            case ISBACK: 
            case LOGOFF: {
                return true;
            }
        }
        if (this.identifier > 0L) {
            body.addElement("24", this.identifier + "");
        }
        return false;
    }

    private boolean filterInput(YMSG9Packet pkt) {
        switch (pkt.service) {
            case LIST: {
                String[] cookieArr = HTTPConnectionHandler.extractCookies(pkt);
                this.cookie = cookieArr[0] + "; " + cookieArr[1];
                break;
            }
            case LOGON: {
                this.identifier = Long.parseLong(pkt.getValue("24"));
                break;
            }
            case MESSAGE: {
                if (pkt.getValue("14") != null) break;
                if (pkt.getValue("10") != null) {
                    pkt.service = ServiceType.ISBACK;
                    break;
                }
                if (pkt.body.length != 0) break;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("HTTP connection: ").append(this.proxyHost).append(":").append(this.proxyPort);
        return sb.toString();
    }

    class Notifier
    extends Thread {
        volatile boolean quitFlag;

        Notifier(String nm) {
            super(nm);
            this.quitFlag = false;
            HTTPConnectionHandler.this.lastFetch = System.currentTimeMillis();
            this.start();
        }

        public void run() {
            while (!this.quitFlag) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long t = System.currentTimeMillis();
                if (this.quitFlag || !HTTPConnectionHandler.this.connected || t - HTTPConnectionHandler.this.lastFetch <= 30000L || HTTPConnectionHandler.this.session.getSessionStatus() != SessionState.LOGGED_ON) continue;
                try {
                    HTTPConnectionHandler.this.session.transmitIdle();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }
}

