/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openymsg.network.ConnectionHandler;
import org.openymsg.network.NetworkConstants;
import org.openymsg.network.PacketBodyBuffer;
import org.openymsg.network.ServiceType;
import org.openymsg.network.Session;
import org.openymsg.network.Util;
import org.openymsg.network.YMSG9InputStream;
import org.openymsg.network.YMSG9Packet;

public class DirectConnectionHandler
extends ConnectionHandler {
    private String host;
    private int port;
    private boolean dontUseFallbacks = false;
    private Socket socket;
    private YMSG9InputStream ips;
    private DataOutputStream ops;
    private static final Log log = LogFactory.getLog(DirectConnectionHandler.class);

    public DirectConnectionHandler(String h, int p) {
        this.host = h;
        this.port = p;
        this.dontUseFallbacks = true;
    }

    public DirectConnectionHandler(int p) {
        this(Util.directHost(), p);
    }

    public DirectConnectionHandler(boolean fl) {
        this();
        this.dontUseFallbacks = fl;
    }

    public DirectConnectionHandler() {
        this(Util.directHost(), Util.directPort());
        this.dontUseFallbacks = false;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    void install(Session ss) {
    }

    void open() throws SocketException, IOException {
        if (this.dontUseFallbacks) {
            this.socket = new Socket(this.host, this.port);
        } else {
            int[] fallbackPorts = Util.directPorts();
            int i = 0;
            while (this.socket == null) {
                try {
                    this.socket = new Socket(this.host, fallbackPorts[i]);
                    this.port = fallbackPorts[i];
                }
                catch (SocketException e) {
                    this.socket = null;
                    if (++i < fallbackPorts.length) continue;
                    throw e;
                }
            }
        }
        log.debug((Object)("Source socket: " + this.socket.getLocalSocketAddress() + " yahoo socket: " + this.socket.getInetAddress() + ":" + this.socket.getPort()));
        this.ips = new YMSG9InputStream(this.socket.getInputStream());
        this.ops = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
    }

    void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        this.ips = null;
        this.ops = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacket(PacketBodyBuffer body, ServiceType service, long status, long sessionId) throws IOException {
        byte[] b = body.getBuffer();
        DataOutputStream dataOutputStream = this.ops;
        synchronized (dataOutputStream) {
            this.ops.write(NetworkConstants.MAGIC, 0, 4);
            this.ops.write(NetworkConstants.VERSION, 0, 4);
            this.ops.writeShort(b.length & 0xFFFF);
            this.ops.writeShort(service.getValue() & 0xFFFF);
            this.ops.writeInt((int)(status & 0xFFFFFFFFFFFFFFFFL));
            this.ops.writeInt((int)(sessionId & 0xFFFFFFFFFFFFFFFFL));
            this.ops.write(b, 0, b.length);
            this.ops.flush();
        }
    }

    protected YMSG9Packet receivePacket() throws IOException {
        return this.ips.readPacket();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Direct connection: ").append(this.host).append(":").append(this.port);
        return sb.toString();
    }

    public void setHost(String host) {
        this.host = host;
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

