/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Vector;
import net.sf.jqql.net.INIOHandler;
import net.sf.jqql.net.IPort;
import net.sf.jqql.net.IProxy;
import net.sf.jqql.packets.PacketParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Porter
extends Thread {
    private static final Log log = LogFactory.getLog(Porter.class);
    protected boolean shutdown = false;
    protected Selector selector;
    private List<IPort> ports = new ArrayList<IPort>();
    private List<IProxy> proxies = new ArrayList<IProxy>();
    private Queue<Object> disposeQueue;
    private List<Object> newConnections = new Vector<Object>();

    public Porter() {
        this.disposeQueue = new LinkedList<Object>();
        this.setName("Porter");
        this.setDaemon(true);
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            log.debug((Object)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public void register(IPort iPort) throws ClosedChannelException {
        SelectableChannel selectableChannel = iPort.channel();
        if (selectableChannel instanceof SocketChannel) {
            selectableChannel.register(this.selector, 8, iPort.getNIOHandler());
        } else if (selectableChannel instanceof DatagramChannel) {
            selectableChannel.register(this.selector, 1, iPort.getNIOHandler());
        }
        if (!this.ports.contains(iPort)) {
            this.ports.add(iPort);
        }
    }

    public void register(IPort iPort, int n) throws ClosedChannelException {
        SelectableChannel selectableChannel = iPort.channel();
        if (selectableChannel instanceof SocketChannel) {
            selectableChannel.register(this.selector, n, iPort.getNIOHandler());
        } else if (selectableChannel instanceof DatagramChannel) {
            selectableChannel.register(this.selector, n, iPort.getNIOHandler());
        }
        if (!this.ports.contains(iPort)) {
            this.ports.add(iPort);
        }
    }

    public void register(IProxy iProxy) throws ClosedChannelException {
        SelectableChannel selectableChannel = iProxy.channel();
        if (selectableChannel instanceof SocketChannel) {
            selectableChannel.register(this.selector, 8, iProxy.getNIOHandler());
        } else if (selectableChannel instanceof DatagramChannel) {
            selectableChannel.register(this.selector, 1, iProxy.getNIOHandler());
        }
        if (!this.proxies.contains(iProxy)) {
            this.proxies.add(iProxy);
        }
    }

    private void deregister(IPort iPort) {
        if (iPort == null) {
            return;
        }
        if (!this.ports.remove(iPort)) {
            return;
        }
        SelectionKey selectionKey = iPort.channel().keyFor(this.selector);
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        iPort.dispose();
    }

    private void deregister(IProxy iProxy) {
        if (iProxy == null) {
            return;
        }
        if (!this.proxies.remove(iProxy)) {
            return;
        }
        SelectionKey selectionKey = iProxy.channel().keyFor(this.selector);
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        iProxy.dispose();
    }

    private void dispatchErrorToAll(Exception exception) {
        for (IPort object : this.ports) {
            object.getNIOHandler().processError(exception);
        }
        for (IProxy iProxy : this.proxies) {
            iProxy.getNIOHandler().processError(exception);
        }
    }

    private void notifySend() {
        INIOHandler iNIOHandler;
        int n;
        int n2 = this.ports.size();
        for (n = 0; n < n2; ++n) {
            iNIOHandler = null;
            try {
                iNIOHandler = this.ports.get(n).getNIOHandler();
                iNIOHandler.processWrite();
                continue;
            }
            catch (IOException iOException) {
                log.error((Object)iOException.getMessage());
                iNIOHandler.processError(iOException);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        n2 = this.proxies.size();
        for (n = 0; n < n2; ++n) {
            iNIOHandler = null;
            try {
                iNIOHandler = this.proxies.get(n).getNIOHandler();
                iNIOHandler.processWrite();
                continue;
            }
            catch (IOException iOException) {
                log.error((Object)iOException.getMessage());
                iNIOHandler.processError(iOException);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void run() {
        log.debug((Object)"Porter\u5df2\u7ecf\u542f\u52a8");
        int n = 0;
        while (!this.shutdown) {
            try {
                n = this.selector.select(3000L);
                if (this.shutdown) {
                    this.selector.close();
                    break;
                }
            }
            catch (IOException iOException) {
                log.error((Object)iOException.getMessage());
                this.dispatchErrorToAll(iOException);
            }
            this.processDisposeQueue();
            if (n > 0) {
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    if (!selectionKey.isValid()) continue;
                    INIOHandler iNIOHandler = (INIOHandler)selectionKey.attachment();
                    try {
                        if (selectionKey.isConnectable()) {
                            iNIOHandler.processConnect(selectionKey);
                            continue;
                        }
                        if (!selectionKey.isReadable()) continue;
                        iNIOHandler.processRead(selectionKey);
                    }
                    catch (IOException iOException) {
                        log.error((Object)iOException.getMessage());
                        iNIOHandler.processError(iOException);
                    }
                    catch (PacketParseException packetParseException) {
                        log.debug((Object)("\u5305\u89e3\u6790\u9519\u8bef: " + packetParseException.getMessage()));
                    }
                    catch (RuntimeException runtimeException) {
                        log.error((Object)runtimeException.getMessage());
                    }
                }
                n = 0;
            }
            this.checkNewConnection();
            this.notifySend();
        }
        this.selector = null;
        this.shutdown = false;
        log.debug((Object)"Porter\u5df2\u7ecf\u9000\u51fa");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeRequest(IPort iPort) {
        Queue<Object> queue = this.disposeQueue;
        synchronized (queue) {
            this.disposeQueue.offer(iPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeRequest(IProxy iProxy) {
        Queue<Object> queue = this.disposeQueue;
        synchronized (queue) {
            this.disposeQueue.offer(iProxy);
        }
    }

    private void checkNewConnection() {
        while (!this.newConnections.isEmpty()) {
            Object object = this.newConnections.remove(0);
            if (object instanceof IProxy) {
                try {
                    this.register((IProxy)object);
                }
                catch (ClosedChannelException closedChannelException) {}
                continue;
            }
            if (!(object instanceof IPort)) continue;
            try {
                this.register((IPort)object);
            }
            catch (ClosedChannelException closedChannelException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDisposeQueue() {
        Queue<Object> queue = this.disposeQueue;
        synchronized (queue) {
            while (!this.disposeQueue.isEmpty()) {
                Object object = this.disposeQueue.poll();
                if (object instanceof IPort) {
                    this.deregister((IPort)object);
                    continue;
                }
                if (!(object instanceof IProxy)) continue;
                this.deregister((IProxy)object);
            }
        }
    }

    public void shutdown() {
        if (this.selector != null) {
            this.shutdown = true;
            this.selector.wakeup();
        }
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public void wakeup(Object object) {
        this.newConnections.add(object);
        this.selector.wakeup();
    }
}

