/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.SRVRecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;

public class DNSJavaResolver
implements DNSResolver {
    private static DNSJavaResolver instance = new DNSJavaResolver();

    private DNSJavaResolver() {
    }

    public static DNSResolver getInstance() {
        return instance;
    }

    @Override
    public List<SRVRecord> lookupSRVRecords(String name) {
        ArrayList<SRVRecord> res = new ArrayList<SRVRecord>();
        try {
            Lookup lookup = new Lookup(name, 33);
            Record[] recs = lookup.run();
            if (recs == null) {
                return res;
            }
            for (Record record : recs) {
                SRVRecord r;
                org.xbill.DNS.SRVRecord srvRecord = (org.xbill.DNS.SRVRecord)record;
                if (srvRecord == null || srvRecord.getTarget() == null) continue;
                String host = srvRecord.getTarget().toString();
                int port = srvRecord.getPort();
                int priority = srvRecord.getPriority();
                int weight = srvRecord.getWeight();
                try {
                    r = new SRVRecord(host, port, priority, weight);
                }
                catch (Exception e) {
                    continue;
                }
                res.add(r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

