/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web.assets;

import com.voxeo.web.CacheMode;
import com.voxeo.web.assets.Asset;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class AbstractAsset
implements Asset {
    boolean minify = true;
    CacheMode cacheMode = CacheMode.FOREVER;
    boolean requiresVersion = true;
    Duration cacheExpiration;

    public boolean isRequiresVersion() {
        return this.requiresVersion;
    }

    public void setRequiresVersion(boolean requiresVersion) {
        this.requiresVersion = requiresVersion;
    }

    public boolean isMinify() {
        return this.minify;
    }

    public void setMinify(boolean minify) {
        this.minify = minify;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public Duration getCacheExpiration() {
        switch (this.getCacheMode()) {
            case BASIC: {
                return this.cacheExpiration;
            }
            case FOREVER: {
                DateTime now = new DateTime();
                DateTime year = now.plusYears(5);
                return new Interval((ReadableInstant)now, (ReadableInstant)year).toDuration();
            }
            case DEFAULT: 
            case NEVER: {
                return new Duration(0L);
            }
        }
        throw new UnsupportedOperationException("Unsupoprted Cache Mode: " + (Object)((Object)this.getCacheMode()));
    }

    public void setCacheExpiration(Duration cacheExpiration) {
        this.cacheExpiration = cacheExpiration;
    }
}

