/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSet {
    private List<Pattern> patterns;

    public PatternSet() {
    }

    public PatternSet(Collection<String> patternStrings) {
        this.setPatterns(patternStrings);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("[PatternSet ");
        if (this.patterns != null) {
            buffer.append(Strings.join(this.patterns, ","));
        }
        buffer.append("]");
        return buffer.toString();
    }

    public boolean matchesAny(String string) {
        boolean result = false;
        if (string != null) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(string).matches()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean matchesAll(String string) {
        if (string == null) {
            return false;
        }
        boolean result = true;
        for (Pattern pattern : this.patterns) {
            if (pattern.matcher(string).matches()) continue;
            result = false;
            break;
        }
        return result;
    }

    public void setPatterns(Collection<String> patternStrings) {
        this.patterns = new ArrayList<Pattern>(patternStrings.size());
        if (patternStrings != null) {
            for (String string : patternStrings) {
                this.patterns.add(Pattern.compile(string));
            }
        }
    }
}

