/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.exceptions.VException;
import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Strings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class Networks {
    private static final Loggerf log = Loggerf.getLogger(Networks.class);
    private static final String[] INTERFACE_NAMES_BY_PRIORITY = new String[]{"en0", "en1", "en2"};
    private static final String IPV6_REGEX = "^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$";

    public static String getLocalhostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isLoopback(String value) {
        if (Strings.isEmpty(value)) {
            return false;
        }
        try {
            InetAddress otherAddress = InetAddress.getByName(value);
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface inter = interfaces.nextElement();
                Enumeration<InetAddress> addresses = inter.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.isLoopbackAddress() || !address.equals(otherAddress)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new VException("Failed to determine if address is loopback [address=%s]", value, e);
        }
    }

    public static String extractDefaultLocalAddress() {
        InetAddress r = Networks.extractDefaultLocalInetAddress();
        if (r != null) {
            return r.getHostAddress();
        }
        return "127.0.0.1";
    }

    public static InetAddress extractDefaultLocalInetAddress() {
        InetAddress r = null;
        for (String name : INTERFACE_NAMES_BY_PRIORITY) {
            try {
                r = Networks.extractFirstNonLoopbackInetAddress(NetworkInterface.getByName(name));
                if (r == null) continue;
                break;
            }
            catch (SocketException e) {
                log.warn("Error extracting name of interface %s", name);
            }
        }
        if (r == null) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements() && (r = Networks.extractFirstNonLoopbackInetAddress(interfaces.nextElement())) == null) {
                }
            }
            catch (SocketException e) {
                throw new IllegalStateException("Error iterating network interfaces");
            }
        }
        return r;
    }

    private static InetAddress extractFirstNonLoopbackInetAddress(NetworkInterface iface) {
        InetAddress r = null;
        if (iface != null) {
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress()) continue;
                r = address;
                break;
            }
        }
        return r;
    }

    public static String extractAddress(NetworkInterface iface) {
        InetAddress r = Networks.extractFirstNonLoopbackInetAddress(iface);
        if (r != null) {
            return r.getHostAddress();
        }
        return null;
    }

    public static String extractName(NetworkInterface iface) {
        String r;
        block1: {
            InetAddress address;
            r = null;
            if (iface == null) break block1;
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements() && ((address = addresses.nextElement()).isLoopbackAddress() || Strings.isEmpty(r = address.getCanonicalHostName()))) {
            }
        }
        return r;
    }

    public static NetworkInterface findInterfaceByIp(String ip) {
        try {
            InetAddress otherAddress = InetAddress.getByName(ip);
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.equals(otherAddress)) continue;
                    return iface;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error querying list of network interfaces", e);
        }
    }

    public static InetAddress findInetAddressByIp(String ip) {
        try {
            InetAddress otherAddress = InetAddress.getByName(ip);
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.equals(otherAddress)) continue;
                    return address;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error querying list of network interfaces", e);
        }
    }

    public static boolean hasInterfaceForIp(String ip) {
        return Networks.findInterfaceByIp(ip) != null;
    }

    public static NetworkInterface findInterfaceByName(String name) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (!iface.getName().equals(name)) continue;
                return iface;
            }
            return null;
        }
        catch (SocketException e) {
            throw new IllegalStateException("Error querying list of network interfaces", e);
        }
    }

    public static boolean isIPv4(String address) {
        try {
            String[] octets = address.split("\\.");
            if (octets.length != 4) {
                return false;
            }
            for (String octet : octets) {
                int intValue = Integer.parseInt(octet);
                if (intValue >= 0 || intValue <= 255) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isIPv6(String address) {
        return address.matches(IPV6_REGEX);
    }

    public static boolean isIP(String address) {
        return Networks.isIPv4(address) || Networks.isIPv6(address);
    }

    public static URL toURL(String protocol, String host, int port, String file) {
        try {
            return new URL(protocol, host, port, file);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String urlEncode(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Socket openSocketInPortRange(String host, int minPort, int maxPort) {
        Socket result = null;
        for (int port = minPort; result == null && port <= maxPort; ++port) {
            try {
                result = new Socket(host, port);
                continue;
            }
            catch (Exception e) {
                log.debug("failed to open socket on %s:%d - %s", host, port, e.getMessage());
            }
        }
        return result;
    }

    public static ServerSocket openServerInPortRange(int minPort, int maxPort) {
        return Networks.openServerInPortRange(minPort, maxPort);
    }

    public static ServerSocket openServerInPortRange(String host, int minPort, int maxPort) {
        ServerSocket result = null;
        for (int port = minPort; result == null && port <= maxPort; ++port) {
            log.trace("attempting to listen on port %d", port);
            try {
                result = new ServerSocket();
                InetSocketAddress address = Strings.isEmpty(host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
                result.bind(address);
                continue;
            }
            catch (Exception e) {
                log.debug("failed to listen port %d - %s", port, e.getMessage());
                result = null;
            }
        }
        return result;
    }

    public static int findFreePort() throws IOException {
        ServerSocket server = new ServerSocket(0);
        int port = server.getLocalPort();
        server.close();
        return port;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            String action = args[0];
            if ("-a".equals(action) || "--address".equals(action)) {
                System.out.println(Networks.extractDefaultLocalAddress());
            } else if ("-h".equals(action) || "--host".equals(action)) {
                System.out.println(Networks.getLocalhostName());
            }
        } else {
            System.out.println("Valid switches are: --address --host");
        }
    }
}

