/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUMemoryCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -7658975982689489740L;
    protected int maxsize;

    public LRUMemoryCache(int maxsize) {
        super(maxsize * 4 / 3 + 1, 0.75f, true);
        this.maxsize = maxsize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxsize;
    }

    public static <K, V> Map<K, V> getSynchronizedLRUCache(int maxSize) {
        LRUMemoryCache<K, V> cache = new LRUMemoryCache<K, V>(maxSize);
        return Collections.synchronizedMap(cache);
    }
}

