/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.Hashes;
import com.voxeo.utils.Pair;
import com.voxeo.utils.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTP {
    public static Map<String, String> getSimpleParameters(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String[] values = request.getParameterValues(key);
            if (values.length != 1) continue;
            map.put(key, values[0]);
        }
        return map;
    }

    public static Map<String, String> parseQueryString(String urlOrQueryString) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String queryString = urlOrQueryString;
            if (queryString != null) {
                int index = urlOrQueryString.lastIndexOf("?");
                if (index > -1) {
                    queryString = urlOrQueryString.substring(index + 1);
                }
                String[] parameters = queryString.split("&");
                for (int i = 0; i < parameters.length; ++i) {
                    int p = parameters[i].indexOf("=");
                    if (p >= 0) {
                        String name = URLDecoder.decode(parameters[i].substring(0, p), "UTF-8");
                        String value = URLDecoder.decode(parameters[i].substring(p + 1), "UTF-8");
                        result.put(name, value);
                        continue;
                    }
                    result.put(parameters[i], null);
                }
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Map<String, String> parseQueryString(URL url) {
        return HTTP.parseQueryString(url.getQuery());
    }

    public static void setExpireHeaders(HttpServletResponse response) {
        HTTP.setExpireHeaders(response, 0L);
    }

    public static void setExpireHeaders(HttpServletResponse response, long timeout) {
        if (timeout == 0L) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "must-revalidate");
            response.setHeader("Cache-Control", "no-store");
            response.setDateHeader("Expires", 0L);
        } else {
            long lCurrentTime = System.currentTimeMillis();
            long lExpirationTime = timeout + lCurrentTime;
            response.addDateHeader("Expires", lExpirationTime);
            response.addDateHeader("Last-Modified", lCurrentTime);
            response.addHeader("Cache-Control", "max-age=" + timeout);
        }
    }

    public static Pair<String, String> extractBasicAuthCredentials(String authorization) {
        try {
            if (!Strings.isEmpty(authorization) && authorization.startsWith("Basic ")) {
                byte[] base64Token = authorization.substring(6).getBytes("UTF-8");
                String token = Hashes.base64Decode(base64Token);
                String username = "";
                String password = "";
                int delim = token.indexOf(":");
                if (delim != -1) {
                    username = token.substring(0, delim);
                    password = token.substring(delim + 1);
                }
                return Pair.make(username, password);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

