/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.exceptions.VException;
import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Strings;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exceptions {
    private static final Loggerf log = Loggerf.getLogger(Exceptions.class);
    private static final String BAD_SIGNATURE = "Could not find Constructor (%s) [class=%s]";
    private static final String BAD_CREATE = "Failed to create Exception with signature (%s) [class=%s]";

    public static <T extends Throwable> T getCauseOfType(Throwable throwable, Class<T> causeClazz) {
        Throwable cause = throwable;
        int maxDepth = 20;
        int depth = 0;
        do {
            if (!causeClazz.isAssignableFrom(cause.getClass())) continue;
            return (T)cause;
        } while ((cause = cause.getCause()) != null && ++depth < 20);
        return null;
    }

    public static <E extends RuntimeException> void fling(Class<E> clazz, String message, Object ... args) {
        throw Exceptions.make(clazz, message, args);
    }

    public static <E extends RuntimeException> E make(Class<E> clazz, String message, Object ... args) {
        message = Strings.format(message, args);
        Throwable wrappedThrowable = Exceptions.extractThrowable(args);
        RuntimeException instance = null;
        Constructor<E> constructor = null;
        if (wrappedThrowable != null) {
            constructor = Exceptions.findConstructor(clazz, String.class, Throwable.class);
            if (constructor != null) {
                try {
                    instance = (RuntimeException)constructor.newInstance(message, wrappedThrowable);
                }
                catch (Exception e) {
                    log.warn(BAD_CREATE, "String.class, Throwable.class", clazz.getName());
                }
                if (instance != null) {
                    return (E)instance;
                }
            } else {
                log.warn(BAD_SIGNATURE, "String.class, Throwable.class", clazz.getName());
            }
        }
        if ((constructor = Exceptions.findConstructor(clazz, String.class)) != null) {
            try {
                instance = (RuntimeException)constructor.newInstance(message);
            }
            catch (Exception e) {
                log.warn(BAD_CREATE, "String.class, Throwable.class", clazz.getName());
            }
            if (instance != null) {
                return (E)instance;
            }
        } else {
            log.warn(BAD_SIGNATURE, "String.class, Throwable.class", clazz.getName());
        }
        if ((constructor = Exceptions.findConstructor(clazz, new Class[0])) != null) {
            try {
                instance = (RuntimeException)constructor.newInstance(message);
            }
            catch (Exception e) {
                log.warn(BAD_CREATE, "NO_ARG", clazz.getName());
            }
            if (instance != null) {
                return (E)instance;
            }
        } else {
            log.warn(BAD_SIGNATURE, "NO_ARG", clazz.getName());
        }
        log.warn("Could not find a suitable contructor for Exception. Throwing VException instead.", new Object[0]);
        throw new VException(message, wrappedThrowable);
    }

    private static <T> Constructor<T> findConstructor(Class<T> clazz, Class<?> ... args) {
        try {
            return clazz.getConstructor(args);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Throwable extractThrowable(Object ... args) {
        Object o;
        Throwable throwable = null;
        if (args.length > 0 && (o = args[args.length - 1]) instanceof Throwable) {
            throwable = (Throwable)o;
        }
        return throwable;
    }
}

