/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public abstract class AbstractDelegatingReadWriteLock
implements Lock {
    public void lock() {
        Lock lock = this.notifyLock();
        try {
            lock.lock();
        }
        catch (RuntimeException e) {
            this.notifyUnlock();
            throw e;
        }
    }

    public void lockInterruptibly() throws InterruptedException {
        Lock lock = this.notifyLock();
        try {
            lock.lockInterruptibly();
        }
        catch (RuntimeException e) {
            this.notifyUnlock();
            throw e;
        }
        catch (InterruptedException e) {
            this.notifyUnlock();
            throw e;
        }
    }

    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public boolean tryLock() {
        Lock lock = this.notifyLock();
        try {
            boolean success = lock.tryLock();
            if (success) {
                this.notifyLock();
            }
            return success;
        }
        catch (RuntimeException e) {
            this.notifyUnlock();
            throw e;
        }
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        Lock lock = this.notifyLock();
        try {
            boolean success = lock.tryLock(time, unit);
            if (success) {
                this.notifyLock();
            }
            return success;
        }
        catch (RuntimeException e) {
            this.notifyUnlock();
            throw e;
        }
    }

    public void unlock() {
        this.getDelegate().unlock();
        this.notifyUnlock();
    }

    protected abstract Lock getDelegate();

    protected abstract Lock notifyLock();

    protected abstract void notifyUnlock();
}

