/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.util;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IRCStringUtils {
    public static String stripControlChars(String msg) {
        Pattern pa = Pattern.compile("\u0003\\p{Digit}\\p{Digit}");
        Matcher ma = pa.matcher(msg);
        Pattern pb = Pattern.compile("\\p{Cntrl}");
        Matcher mb = pb.matcher(ma.replaceAll(""));
        return mb.replaceAll("");
    }

    public static String convertToHTML(String msg) {
        StringCharacterIterator ci = new StringCharacterIterator(msg);
        String htmlStr = "";
        ArrayList<String> formatList = new ArrayList<String>();
        char c = ci.first();
        while (c != '\uffff') {
            if (c == '\u0002') {
                if (formatList.contains("</b>")) {
                    formatList.remove("</b>");
                    htmlStr = htmlStr + "</b>";
                } else {
                    formatList.add("</b>");
                    htmlStr = htmlStr + "<b>";
                }
            } else if (c == '\u001f') {
                if (formatList.contains("</u>")) {
                    formatList.remove("</u>");
                    htmlStr = htmlStr + "</u>";
                } else {
                    formatList.add("</u>");
                    htmlStr = htmlStr + "<u>";
                }
            } else if (c == '\u0016') {
                if (formatList.contains("</i>")) {
                    formatList.remove("</i>");
                    htmlStr = htmlStr + "</i>";
                } else {
                    formatList.add("</i>");
                    htmlStr = htmlStr + "<i>";
                }
            } else if (c == '\u000f' || c == '\u0015') {
                for (String f : formatList) {
                    htmlStr = htmlStr + f;
                }
                formatList.clear();
            } else {
                htmlStr = htmlStr + c;
            }
            c = ci.next();
        }
        for (String f : formatList) {
            htmlStr = htmlStr + f;
        }
        formatList.clear();
        return IRCStringUtils.stripControlChars(htmlStr);
    }
}

