/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr;

import f00f.net.irc.martyr.ClientStateMonitor;
import f00f.net.irc.martyr.Command;
import f00f.net.irc.martyr.CommandObserver;
import f00f.net.irc.martyr.CommandRegister;
import f00f.net.irc.martyr.CommandSender;
import f00f.net.irc.martyr.CronManager;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.InputHandler;
import f00f.net.irc.martyr.OutCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.StateObserver;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.UnknownCommand;
import f00f.net.irc.martyr.errors.UnknownError;
import f00f.net.irc.martyr.replies.UnknownReply;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Observer;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class IRCConnection {
    static Logger log = Logger.getLogger(IRCConnection.class);
    private CommandSender commandSender;
    private CronManager cronManager;
    private State state;
    private ClientState clientState;
    private StateObserver stateObservers;
    private CommandObserver commandObservers;
    private Socket socket;
    private final Object socketMonitor = new Object();
    private final Object connectMonitor = new Object();
    private final Object eventMonitor = new Object();
    private boolean disconnectPending = false;
    private BufferedWriter socketWriter;
    private CommandRegister commandRegister;
    private InputHandler inputHandler;
    private final Object inputHandlerMonitor = new Object();
    private LinkedList<State> stateQueue;
    private LinkedList<String> localEventQueue;
    private boolean settingState = false;
    private EventThread eventThread;
    private int sendDelay = 300;
    private boolean connected = false;
    private boolean daemon = false;

    public IRCConnection() {
        this(new ClientState());
    }

    public IRCConnection(ClientState clientState) {
        this.stateObservers = new StateObserver();
        this.commandObservers = new CommandObserver();
        this.clientState = clientState;
        this.stateQueue = new LinkedList();
        this.commandRegister = new CommandRegister();
        this.commandSender = new DefaultCommandSender();
        this.setState(State.UNCONNECTED);
        new ClientStateMonitor(this);
        this.localEventQueue = new LinkedList();
        this.eventThread = new EventThread();
        this.eventThread.setDaemon(true);
        this.startEventThread();
    }

    protected void startEventThread() {
        this.eventThread.start();
    }

    public void stop() {
        this.eventThread.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String server, int port) throws IOException {
        Object object = this.connectMonitor;
        synchronized (object) {
            log.debug((Object)("IRCConnection: Connecting to " + server + ":" + port));
            if (this.connected) {
                log.error((Object)"IRCConnection: Connect requested, but we are already connected!");
                return;
            }
            this.connectUnsafe(new Socket(server, port), server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Socket customSocket, String server) throws IOException, IllegalStateException {
        Object object = this.connectMonitor;
        synchronized (object) {
            if (this.connected) {
                throw new IllegalStateException("Connect requested, but we are already connected!");
            }
            this.connectUnsafe(customSocket, server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.eventMonitor;
        synchronized (object) {
            this.disconnectPending = true;
            this.eventMonitor.notifyAll();
        }
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(long timeout) {
        try {
            Object object = this.inputHandlerMonitor;
            synchronized (object) {
                if (this.inputHandler != null) {
                    this.inputHandler.signalShutdown();
                }
                Object object2 = this.socketMonitor;
                synchronized (object2) {
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                if (this.inputHandler != null) {
                    this.inputHandler.join(timeout);
                }
            }
            this.eventThread.shutdown();
            this.eventThread.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return "IRCConnection";
    }

    public void addStateObserver(Observer observer) {
        log.debug((Object)("IRCConnection: Added state observer " + observer));
        this.stateObservers.addObserver(observer);
    }

    public void removeStateObserver(Observer observer) {
        log.debug((Object)("IRCConnection: Removed state observer " + observer));
        this.stateObservers.deleteObserver(observer);
    }

    public void addCommandObserver(Observer observer) {
        log.debug((Object)("IRCConnection: Added command observer " + observer));
        this.commandObservers.addObserver(observer);
    }

    public void removeCommandObserver(Observer observer) {
        log.debug((Object)("IRCConnection: Removed command observer " + observer));
        this.commandObservers.deleteObserver(observer);
    }

    public State getState() {
        return this.state;
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public void sendCommand(Command command) {
        this.sendCommand((OutCommand)command);
    }

    public void sendCommand(OutCommand command) {
        this.commandSender.sendCommand(command);
    }

    public CommandSender getCommandSender() {
        return this.commandSender;
    }

    public void setCommandSender(CommandSender sender) {
        this.commandSender = sender;
    }

    public String getLocalhost() {
        return "localhost";
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public String getRemotehost() {
        return this.clientState.getServer();
    }

    public void setSendDelay(int sleepTime) {
        this.sendDelay = sleepTime;
    }

    public CronManager getCronManager() {
        if (this.cronManager == null) {
            this.cronManager = new CronManager();
        }
        return this.cronManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectCommand(String fakeCommand) {
        Object object = this.eventMonitor;
        synchronized (object) {
            this.localEventQueue.add(fakeCommand);
            this.eventMonitor.notifyAll();
        }
    }

    void socketError(IOException ioe) {
        log.debug((Object)"Socket error called.");
        log.fatal((Object)"Socket error", (Throwable)ioe);
        this.disconnect();
    }

    public static String[] parseRawString(String wholeString) {
        String prefix = "";
        String params = "";
        StringTokenizer tokens = new StringTokenizer(wholeString, " ");
        if (wholeString.charAt(0) == ':') {
            prefix = tokens.nextToken();
            prefix = prefix.substring(1, prefix.length());
        }
        String identifier = tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            params = tokens.nextToken("");
        }
        String[] result = new String[]{prefix, identifier, params};
        return result;
    }

    protected InCommand getCommandObject(String prefix, String identifier, String params) {
        InCommand command;
        InCommand commandFactory = this.commandRegister.getCommand(identifier);
        if (commandFactory == null) {
            if (UnknownError.isError(identifier)) {
                command = new UnknownError(identifier);
                log.warn((Object)("IRCConnection: Using " + command));
            } else if (UnknownReply.isReply(identifier)) {
                command = new UnknownReply(identifier);
                log.warn((Object)("IRCConnection: Using " + command));
            } else {
                log.warn((Object)"IRCConnection: Unknown command");
                command = new UnknownCommand();
            }
        } else {
            command = commandFactory.parse(prefix, identifier, params);
            if (command == null) {
                log.error((Object)("IRCConnection: CommandFactory[" + commandFactory + "] returned NULL"));
                return null;
            }
            log.debug((Object)("IRCConnection: Using " + command));
        }
        return command;
    }

    void incomingCommand(String wholeString) {
        String[] cmdBits;
        log.info((Object)("IRCConnection: RCV = " + wholeString));
        try {
            cmdBits = IRCConnection.parseRawString(wholeString);
        }
        catch (Exception e) {
            this.handleUnparsableCommand(wholeString, e);
            return;
        }
        String prefix = cmdBits[0];
        String identifier = cmdBits[1];
        String params = cmdBits[2];
        InCommand command = this.getCommandObject(prefix, identifier, params);
        command.setSourceString(wholeString);
        this.localCommandUpdate(command);
    }

    protected void handleUnparsableCommand(String wholeString, Exception e) {
        log.error((Object)"Unable to parse server message.", (Throwable)e);
    }

    private void localCommandUpdate(InCommand command) {
        State cmdState = command.getState();
        if (cmdState != State.UNKNOWN && cmdState != this.getState()) {
            this.setState(cmdState);
        }
        try {
            this.commandObservers.setChanged();
            this.commandObservers.notifyObservers(command);
        }
        catch (Throwable e) {
            log.error((Object)"IRCConnection: Command notify failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectUnsafe(Socket socket, String server) throws IOException {
        Object object = this.socketMonitor;
        synchronized (object) {
            this.socket = socket;
        }
        this.socketWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        BufferedReader socketReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        Object object2 = this.inputHandlerMonitor;
        synchronized (object2) {
            if (this.inputHandler != null && this.inputHandler.pendingMessages()) {
                log.fatal((Object)"IRCConnection: Tried to connect, but there are pending messages!");
                return;
            }
            if (this.inputHandler != null && this.inputHandler.isAlive()) {
                log.fatal((Object)"IRCConnection: Tried to connect, but the input handler is still alive!");
                return;
            }
            this.clientState.setServer(server);
            this.clientState.setPort(socket.getPort());
            this.connected = true;
            this.inputHandler = new InputHandler(socketReader, this, this.eventMonitor);
            this.inputHandler.setDaemon(this.daemon);
            this.inputHandler.start();
        }
        this.setState(State.UNREGISTERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processEvents() {
        boolean events = false;
        Object object = this.inputHandlerMonitor;
        synchronized (object) {
            String msg;
            while (this.inputHandler != null && this.inputHandler.pendingMessages()) {
                msg = this.inputHandler.getMessage();
                this.incomingCommand(msg);
                events = true;
            }
            while (this.localEventQueue != null && !this.localEventQueue.isEmpty()) {
                msg = this.localEventQueue.removeFirst();
                this.incomingCommand(msg);
                events = true;
            }
            if (this.disconnectPending) {
                log.debug((Object)"IRCConnection: Process events: Disconnect pending.");
                this.doDisconnect();
                events = true;
            }
        }
        return events;
    }

    private boolean pendingEvents() {
        if (this.inputHandler != null && this.inputHandler.pendingMessages()) {
            return true;
        }
        if (this.disconnectPending) {
            return true;
        }
        return this.localEventQueue != null && !this.localEventQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisconnect() {
        Object object = this.connectMonitor;
        synchronized (object) {
            this.disconnectPending = false;
            if (!this.connected) {
                return;
            }
            this.connected = false;
            try {
                long startTime = System.currentTimeMillis();
                long sleepTime = 1000L;
                long stopTime = startTime + 1000L;
                log.debug((Object)"IRCConnection: Sleeping for a bit (1000)..");
                while (stopTime - System.currentTimeMillis() > 0L) {
                    this.connectMonitor.wait(stopTime - System.currentTimeMillis());
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            log.debug((Object)"IRCConnection: Stopping input handler.");
            log.debug((Object)"IRCConnection: Closing socket.");
            try {
                this.socket.close();
            }
            catch (IOException ioe) {
                this.handleSocketCloseException(ioe);
                return;
            }
            finally {
                this.connected = false;
            }
        }
        object = this.inputHandlerMonitor;
        synchronized (object) {
            log.debug((Object)"IRCConnection: Waiting for the input handler to die..");
            try {
                if (this.inputHandler.isAlive()) {
                    this.inputHandler.join();
                } else {
                    log.debug((Object)"IRCConnection: No waiting required, input hander is already dead.");
                }
            }
            catch (InterruptedException ie) {
                log.debug((Object)("IRCConnection: Error in join(): " + ie));
            }
            log.debug((Object)"IRCConnection: Done waiting for the input handler to die.");
        }
        this.processEvents();
        this.setState(State.UNCONNECTED);
    }

    protected void handleSocketCloseException(IOException ioe) {
        log.warn((Object)"Error closing socket.", (Throwable)ioe);
    }

    private void setState(State newState) {
        if (this.settingState) {
            this.stateQueue.addLast(newState);
            return;
        }
        this.settingState = true;
        if (this.state == newState) {
            return;
        }
        while (true) {
            this.state = newState;
            log.debug((Object)("IRCConnection: State switch: " + this.state));
            try {
                this.stateObservers.setChanged();
                this.stateObservers.notifyObservers(newState);
            }
            catch (Throwable e) {
                log.error((Object)"IRCConnection: State update failed.", e);
            }
            if (this.stateQueue.isEmpty()) break;
            newState = this.stateQueue.removeFirst();
        }
        this.settingState = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalSendCommand(String str) {
        try {
            Object object = this.eventMonitor;
            synchronized (object) {
                log.info((Object)("IRCConnection: SEND= " + str));
                if (this.disconnectPending) {
                    log.debug((Object)"IRCConnection: Send cancelled, disconnect pending.");
                    return;
                }
                this.socketWriter.write(str + "\r\n");
                this.socketWriter.flush();
                try {
                    Thread.sleep(this.sendDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException ioe) {
            this.socketError(ioe);
        }
    }

    private class DefaultCommandSender
    implements CommandSender {
        private DefaultCommandSender() {
        }

        public CommandSender getNextCommandSender() {
            return null;
        }

        public void sendCommand(OutCommand oc) {
            IRCConnection.this.finalSendCommand(oc.render());
        }
    }

    private class EventThread
    extends Thread {
        private boolean doShutdown;

        public EventThread() {
            super("EventThread");
            this.doShutdown = false;
        }

        public void run() {
            this.handleEvents();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = IRCConnection.this.eventMonitor;
            synchronized (object) {
                this.doShutdown = true;
                IRCConnection.this.eventMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleEvents() {
            try {
                while (true) {
                    log.debug((Object)"IRCConnection: Processing events");
                    while (IRCConnection.this.processEvents()) {
                    }
                    Object object = IRCConnection.this.eventMonitor;
                    synchronized (object) {
                        if (!this.doShutdown && !IRCConnection.this.pendingEvents()) {
                            IRCConnection.this.eventMonitor.wait();
                        }
                        if (this.doShutdown) {
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
                log.warn((Object)"Interrupted while handling events.", (Throwable)ie);
                return;
            }
        }

        public void doStop() {
            this.shutdown();
        }

        public String toString() {
            return "EventThread";
        }
    }
}

