/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.GGException;
import pl.mn.communicator.GGSessionException;
import pl.mn.communicator.ILocalStatus;
import pl.mn.communicator.IPresenceService;
import pl.mn.communicator.IRemoteStatus;
import pl.mn.communicator.IUser;
import pl.mn.communicator.LocalStatus;
import pl.mn.communicator.Session;
import pl.mn.communicator.SessionState;
import pl.mn.communicator.StatusType;
import pl.mn.communicator.User;
import pl.mn.communicator.event.LoginListener;
import pl.mn.communicator.event.UserListener;
import pl.mn.communicator.packet.out.GGAddNotify;
import pl.mn.communicator.packet.out.GGListEmpty;
import pl.mn.communicator.packet.out.GGNewStatus;
import pl.mn.communicator.packet.out.GGNotify;
import pl.mn.communicator.packet.out.GGOutgoingPackage;
import pl.mn.communicator.packet.out.GGRemoveNotify;

public class DefaultPresenceService
implements IPresenceService {
    private static final Log LOGGER = LogFactory.getLog((Class)DefaultPresenceService.class);
    private Set m_userListeners = new HashSet();
    private Session m_session = null;
    private ILocalStatus m_localStatus = new LocalStatus(StatusType.OFFLINE);
    private Map m_monitoredUsers = new HashMap();

    DefaultPresenceService(Session session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        this.m_session = session;
        this.m_session.getLoginService().addLoginListener(new LoginHandler());
    }

    public void setStatus(ILocalStatus localStatus) throws GGException {
        if (localStatus == null) {
            throw new NullPointerException("status cannot be null");
        }
        this.checkSessionState();
        try {
            GGNewStatus newStatus = new GGNewStatus(localStatus);
            this.m_session.getSessionAccessor().sendPackage(newStatus);
            this.m_localStatus = localStatus;
            this.notifyLocalUserChangedStatus(localStatus);
        }
        catch (IOException ex) {
            throw new GGException("Unable to set status: " + localStatus, ex);
        }
    }

    public ILocalStatus getStatus() {
        return this.m_localStatus;
    }

    public void addMonitoredUser(IUser user) throws GGException {
        if (user == null) {
            throw new NullPointerException("user cannot be null");
        }
        this.checkSessionState();
        if (this.m_monitoredUsers.containsKey(user)) {
            return;
        }
        try {
            GGAddNotify addNotify = new GGAddNotify(user.getUin(), user.getUserMode());
            this.m_session.getSessionAccessor().sendPackage(addNotify);
            this.m_monitoredUsers.put(user, user);
        }
        catch (IOException ex) {
            throw new GGException("Error occured while adding user to be monitored.", ex);
        }
    }

    public void removeMonitoredUser(IUser user) throws GGException {
        if (user == null) {
            throw new NullPointerException("user cannot be null");
        }
        this.checkSessionState();
        if (!this.m_monitoredUsers.containsKey(user)) {
            throw new GGException("User: " + user + "+ is not monitored");
        }
        try {
            GGRemoveNotify removeNotify = new GGRemoveNotify(user.getUin(), user.getUserMode());
            this.m_session.getSessionAccessor().sendPackage(removeNotify);
            this.m_monitoredUsers.remove(user);
        }
        catch (IOException ex) {
            throw new GGException("Unable to remove monitored user", ex);
        }
    }

    public void changeMonitoredUserStatus(IUser user) throws GGException {
        if (user == null) {
            throw new NullPointerException("user cannot be null");
        }
        this.checkSessionState();
        IUser oldUser = (IUser)this.m_monitoredUsers.get(user);
        if (null == oldUser) {
            throw new GGException("User: " + user + "+ is not monitored");
        }
        User.UserMode oldUserMode = oldUser.getUserMode();
        if (oldUserMode.equals(user.getUserMode())) {
            throw new GGException("User: " + user + "+ is already being monitored with status " + oldUserMode);
        }
        try {
            GGRemoveNotify removeNotify = new GGRemoveNotify(user.getUin(), oldUserMode);
            this.m_session.getSessionAccessor().sendPackage(removeNotify);
            GGAddNotify addNotify = new GGAddNotify(user.getUin(), user.getUserMode());
            this.m_session.getSessionAccessor().sendPackage(addNotify);
            this.m_monitoredUsers.remove(oldUser);
            this.m_monitoredUsers.put(user, user);
        }
        catch (IOException ex) {
            throw new GGException("Unable to remove monitored user", ex);
        }
    }

    public Collection getMonitoredUsers() {
        if (this.m_session.getSessionState() != SessionState.LOGGED_IN) {
            return Collections.EMPTY_LIST;
        }
        if (this.m_monitoredUsers.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.m_monitoredUsers.values());
    }

    public void addUserListener(UserListener userListener) {
        if (userListener == null) {
            throw new NullPointerException("userListener cannot be null");
        }
        this.m_userListeners.add(userListener);
    }

    public void removeUserListener(UserListener userListener) {
        if (userListener == null) {
            throw new NullPointerException("userListener cannot be null");
        }
        this.m_userListeners.remove(userListener);
    }

    protected void notifyUserChangedStatus(IUser user, IRemoteStatus newStatus) throws GGException {
        if (user == null) {
            throw new NullPointerException("user cannot be null");
        }
        if (newStatus == null) {
            throw new NullPointerException("newStatus cannot be null");
        }
        Iterator it = this.m_userListeners.iterator();
        while (it.hasNext()) {
            UserListener userListener = (UserListener)it.next();
            userListener.userStatusChanged(user, newStatus);
        }
    }

    protected void notifyLocalUserChangedStatus(ILocalStatus localStatus) throws GGException {
        if (localStatus == null) {
            throw new NullPointerException("localStatus cannot be null");
        }
        Iterator it = this.m_userListeners.iterator();
        while (it.hasNext()) {
            UserListener userListener = (UserListener)it.next();
            userListener.localStatusChanged(localStatus);
        }
    }

    private void checkSessionState() throws GGSessionException {
        if (this.m_session.getSessionState() != SessionState.LOGGED_IN) {
            throw new GGSessionException(this.m_session.getSessionState());
        }
    }

    private class LoginHandler
    extends LoginListener.Stub {
        private LoginHandler() {
        }

        public void loginOK() throws GGException {
            Collection monitoredUsers = DefaultPresenceService.this.m_session.getLoginService().getLoginContext().getMonitoredUsers();
            DefaultPresenceService.this.m_localStatus = DefaultPresenceService.this.m_session.getLoginService().getLoginContext().getStatus();
            Iterator it = monitoredUsers.iterator();
            while (it.hasNext()) {
                IUser monitoredUser = (IUser)it.next();
                DefaultPresenceService.this.m_monitoredUsers.put(monitoredUser, monitoredUser);
            }
            DefaultPresenceService.this.setStatus(DefaultPresenceService.this.m_localStatus);
            GGOutgoingPackage outgoingPackage = null;
            if (monitoredUsers.size() == 0) {
                outgoingPackage = GGListEmpty.getInstance();
            } else {
                IUser[] users = monitoredUsers.toArray(IUser.EMPTY_ARRAY);
                outgoingPackage = new GGNotify(users);
            }
            try {
                DefaultPresenceService.this.m_session.getSessionAccessor().sendPackage(outgoingPackage);
            }
            catch (IOException ex) {
                throw new GGException("Unable to send initial list of users to monitor", ex);
            }
        }
    }
}

