/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.moho.media.input;

import com.voxeo.moho.media.MediaResource;
import com.voxeo.moho.media.input.JSGFGrammar;
import com.voxeo.moho.media.input.SimpleGrammar;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class Grammar
implements MediaResource {
    private static final Logger LOG = Logger.getLogger(JSGFGrammar.class);
    protected URI _uri;
    protected String _text = null;
    protected String _contentType = null;
    protected boolean _isTerminatingCondition = true;

    public Grammar() {
    }

    public Grammar(String contentType, String contents) {
        this._contentType = contentType;
        this._text = contents;
    }

    public Grammar(URI uri) {
        this._uri = uri;
    }

    public Grammar(String contentType, String contents, boolean terminating) {
        this(contents, contents);
        this._isTerminatingCondition = terminating;
    }

    public Grammar(URI uri, boolean terminating) {
        this(uri);
        this._isTerminatingCondition = terminating;
    }

    public String getText() {
        return this._text;
    }

    public URI getUri() {
        return this._uri;
    }

    public String getContentType() {
        return this._contentType;
    }

    @Override
    public URI toURI() {
        if (this._uri == null) {
            try {
                return URI.create("data:" + URLEncoder.encode(this.getContentType() + "," + this.getText(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)"", (Throwable)e);
                return URI.create("data:" + URLEncoder.encode(this.getContentType() + "," + this.getText()));
            }
        }
        return this._uri;
    }

    public static Grammar create(String grammar) {
        if (grammar.startsWith("#JSGF")) {
            return new JSGFGrammar(grammar);
        }
        return new SimpleGrammar(grammar);
    }

    public static Grammar create(Reader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        char[] charbuf = new char[1024];
        int readLength = 0;
        while ((readLength = reader.read(charbuf)) > 0) {
            sb.append(charbuf, 0, readLength);
        }
        String grammar = sb.toString();
        if (grammar.startsWith("#JSGF")) {
            return new JSGFGrammar(grammar);
        }
        return new SimpleGrammar(grammar);
    }

    public boolean isTerminatingCondition() {
        return this._isTerminatingCondition;
    }
}

