/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.jml.Email;
import net.sf.jml.MsnFileTransferState;
import net.sf.jml.impl.AbstractFileTransfer;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.message.p2p.FileTransferWorker;
import net.sf.jml.message.p2p.MsnP2PMessage;
import net.sf.jml.message.p2p.MsnP2PSlpMessage;
import net.sf.jml.protocol.MsnSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MsnFileTransferImpl
extends AbstractFileTransfer {
    private static final Log logger = LogFactory.getLog(MsnFileTransferImpl.class);
    private boolean started = false;
    private boolean sender = false;
    private MsnP2PSlpMessage reqMessage = null;
    private MsnSession session = null;
    private String sessionId = null;
    private Email email = null;

    public MsnFileTransferImpl(String string, Email email, MsnP2PSlpMessage msnP2PSlpMessage, MsnSession msnSession, boolean bl) {
        super(null, null);
        this.email = email;
        this.sessionId = string;
        this.sender = bl;
        this.reqMessage = msnP2PSlpMessage;
        this.session = msnSession;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.setState(MsnFileTransferState.ACCEPTED);
        FileTransferWorker fileTransferWorker = this.getSession().getMessenger().getFileTransferManager().getFileTransferWorker(this.sessionId);
        fileTransferWorker.startFileTransfer();
        this.started = true;
        ((AbstractMessenger)this.getSession().getMessenger()).fireFileTransferStarted(this);
    }

    public void cancel() {
        this.cancel(true);
    }

    public void refuse() {
        this.setState(MsnFileTransferState.REFUSED);
        ((AbstractMessenger)this.getSession().getMessenger()).fireFileTransferFinished(this);
        this.getSession().getMessenger().getFileTransferManager().removeFileTransfer(this.getID());
    }

    public void cancel(boolean bl) {
        FileTransferWorker fileTransferWorker;
        this.setState(MsnFileTransferState.CANCELED);
        if (bl && (fileTransferWorker = this.getSession().getMessenger().getFileTransferManager().getFileTransferWorker(this.sessionId)) != null) {
            fileTransferWorker.cancelFileTransfer();
        }
        ((AbstractMessenger)this.getSession().getMessenger()).fireFileTransferFinished(this);
        this.getSession().getMessenger().getFileTransferManager().removeFileTransfer(this.getID());
    }

    public boolean isSender() {
        return this.sender;
    }

    public String getID() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(byte[] byArray, int n, long l, long l2, MsnP2PMessage msnP2PMessage) {
        if (this.getState() == MsnFileTransferState.CANCELED) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.getFile(), true);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
            this.setTransferredSize(this.getTransferredSize() + (long)n);
            ((AbstractMessenger)this.getSession().getMessenger()).fireFileTransferProcess(this);
            if (this.getTransferredSize() == this.getFileTotalSize()) {
                this.setState(MsnFileTransferState.COMPLETED);
                this.getSession().getMessenger().getFileTransferManager().getFileTransferWorker(this.sessionId).sendP2PAck(msnP2PMessage, true);
                ((AbstractMessenger)this.getSession().getMessenger()).fireFileTransferFinished(this);
                this.getSession().getMessenger().getFileTransferManager().removeFileTransfer(this.sessionId);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Cannot save to this file:" + this.getFile()), (Throwable)exception);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                logger.error(null, (Throwable)iOException);
            }
        }
    }

    public MsnSession getSession() {
        return this.session;
    }

    public MsnP2PSlpMessage getReqMessage() {
        return this.reqMessage;
    }

    public Email getEmail() {
        return this.email;
    }
}

