/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function.ext;

import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public abstract class LocaleFunctionSupport
implements Function {
    protected Locale getLocale(Object value, Navigator navigator) {
        if (value instanceof Locale) {
            return (Locale)value;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                return this.getLocale(list.get(0), navigator);
            }
        } else {
            String text = StringFunction.evaluate(value, navigator);
            if (text != null && text.length() > 0) {
                return this.findLocale(text);
            }
        }
        return null;
    }

    protected Locale findLocale(String localeText) {
        StringTokenizer stringTokenizer = new StringTokenizer(localeText, "-");
        if (stringTokenizer.hasMoreTokens()) {
            String language = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                return this.findLocaleForLanguage(language);
            }
            String country = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                return new Locale(language, country);
            }
            String variant = stringTokenizer.nextToken();
            return new Locale(language, country, variant);
        }
        return null;
    }

    protected Locale findLocaleForLanguage(String language) {
        Locale[] locales = Locale.getAvailableLocales();
        int i = 0;
        int size = locales.length;
        while (i < size) {
            String variant;
            String country;
            Locale locale = locales[i];
            if (!(!language.equals(locale.getLanguage()) || (country = locale.getCountry()) != null && country.length() != 0 || (variant = locale.getVariant()) != null && variant.length() != 0)) {
                return locale;
            }
            ++i;
        }
        return null;
    }

    public abstract Object call(Context var1, List var2) throws FunctionCallException;
}

