/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.TimeZone;
import org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import org.apache.tools.ant.taskdefs.cvslib.RCSFile;

class ChangeLogWriter {
    private static final SimpleDateFormat c_outputDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat c_outputTime = new SimpleDateFormat("HH:mm");

    public void printChangeLog(PrintWriter output, CVSEntry[] entries) {
        output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        output.println("<changelog>");
        int i = 0;
        while (i < entries.length) {
            CVSEntry entry = entries[i];
            this.printEntry(output, entry);
            ++i;
        }
        output.println("</changelog>");
        output.flush();
        output.close();
    }

    private final void printEntry(PrintWriter output, CVSEntry entry) {
        output.println("\t<entry>");
        output.println("\t\t<date>" + c_outputDate.format(entry.getDate()) + "</date>");
        output.println("\t\t<time>" + c_outputTime.format(entry.getDate()) + "</time>");
        output.println("\t\t<author><![CDATA[" + entry.getAuthor() + "]]></author>");
        Enumeration enumeration = entry.getFiles().elements();
        while (enumeration.hasMoreElements()) {
            RCSFile file = (RCSFile)enumeration.nextElement();
            output.println("\t\t<file>");
            output.println("\t\t\t<name>" + file.getName() + "</name>");
            output.println("\t\t\t<revision>" + file.getRevision() + "</revision>");
            String previousRevision = file.getPreviousRevision();
            if (previousRevision != null) {
                output.println("\t\t\t<prevrevision>" + previousRevision + "</prevrevision>");
            }
            output.println("\t\t</file>");
        }
        output.println("\t\t<msg><![CDATA[" + entry.getComment() + "]]></msg>");
        output.println("\t</entry>");
    }

    ChangeLogWriter() {
    }

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        c_outputDate.setTimeZone(utc);
        c_outputTime.setTimeZone(utc);
    }
}

