/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2.optional;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class PooledConnectionImpl
implements PooledConnection {
    private List listeners = new LinkedList();
    private Connection con;
    private ConnectionHandler last;
    private boolean autoCommit;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$org$postgresql$PGConnection;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$org$postgresql$PGStatement;
    static /* synthetic */ Class class$java$sql$CallableStatement;
    static /* synthetic */ Class class$java$sql$PreparedStatement;

    protected PooledConnectionImpl(Connection con, boolean autoCommit) {
        this.con = con;
        this.autoCommit = autoCommit;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.last != null) {
            this.last.close();
            if (!this.con.getAutoCommit()) {
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        try {
            this.con.close();
        }
        finally {
            this.con = null;
        }
    }

    public Connection getConnection() throws SQLException {
        ConnectionHandler handler;
        if (this.con == null) {
            SQLException sqlException = new SQLException("This PooledConnection has already been closed!");
            this.fireConnectionFatalError(sqlException);
            throw sqlException;
        }
        try {
            if (this.last != null) {
                this.last.close();
                if (!this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                this.con.clearWarnings();
            }
            this.con.setAutoCommit(this.autoCommit);
        }
        catch (SQLException sqlException) {
            this.fireConnectionFatalError(sqlException);
            throw (SQLException)sqlException.fillInStackTrace();
        }
        this.last = handler = new ConnectionHandler(this.con);
        Connection con = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = PooledConnectionImpl.class$("java.sql.Connection")) : class$java$sql$Connection, class$org$postgresql$PGConnection == null ? (class$org$postgresql$PGConnection = PooledConnectionImpl.class$("org.postgresql.PGConnection")) : class$org$postgresql$PGConnection}, (InvocationHandler)handler);
        this.last.setProxy(con);
        return con;
    }

    void fireConnectionClosed() {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i = 0; i < local.length; ++i) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = new ConnectionEvent(this);
            }
            listener.connectionClosed(evt);
        }
    }

    void fireConnectionFatalError(SQLException e) {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i = 0; i < local.length; ++i) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = new ConnectionEvent(this, e);
            }
            listener.connectionErrorOccurred(evt);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class StatementHandler
    implements InvocationHandler {
        private ConnectionHandler con;
        private Statement st;

        public StatementHandler(ConnectionHandler con, Statement st) {
            this.con = con;
            this.st = st;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled statement wrapping physical statement " + this.st;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.st.hashCode());
                }
                if (method.getName().equals("equals")) {
                    if (args[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        return Proxy.isProxyClass(args[0].getClass()) && ((StatementHandler)Proxy.getInvocationHandler((Object)args[0])).st == this.st ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException e) {
                        return Boolean.FALSE;
                    }
                }
                return method.invoke((Object)this.st, args);
            }
            if (method.getName().equals("close")) {
                if (this.st == null || this.con.isClosed()) {
                    return null;
                }
                try {
                    this.st.close();
                }
                finally {
                    this.con = null;
                    this.st = null;
                }
                return null;
            }
            if (this.st == null || this.con.isClosed()) {
                throw new SQLException("Statement has been closed");
            }
            if (method.getName().equals("getConnection")) {
                return this.con.getProxy();
            }
            try {
                return method.invoke((Object)this.st, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection con;
        private Connection proxy;
        private boolean automatic = false;

        public ConnectionHandler(Connection con) {
            this.con = con;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled connection wrapping physical connection " + this.con;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.con.hashCode());
                }
                if (method.getName().equals("equals")) {
                    if (args[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        return Proxy.isProxyClass(args[0].getClass()) && ((ConnectionHandler)Proxy.getInvocationHandler((Object)args[0])).con == this.con ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException e) {
                        return Boolean.FALSE;
                    }
                }
                try {
                    return method.invoke((Object)this.con, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            if (method.getName().equals("isClosed")) {
                return this.con == null ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.con == null && !method.getName().equals("close")) {
                throw new SQLException(this.automatic ? "Connection has been closed automatically because a new connection was opened for the same PooledConnection or the PooledConnection has been closed" : "Connection has been closed");
            }
            if (method.getName().equals("close")) {
                if (this.con == null) {
                    return null;
                }
                SQLException ex = null;
                if (!this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException e) {
                        ex = e;
                    }
                }
                this.con.clearWarnings();
                this.con = null;
                proxy = null;
                PooledConnectionImpl.this.last = null;
                PooledConnectionImpl.this.fireConnectionClosed();
                if (ex != null) {
                    throw ex;
                }
                return null;
            }
            if (method.getName().equals("createStatement")) {
                Statement st = (Statement)method.invoke((Object)this.con, args);
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$Statement == null ? (class$java$sql$Statement = PooledConnectionImpl.class$("java.sql.Statement")) : class$java$sql$Statement, class$org$postgresql$PGStatement == null ? (class$org$postgresql$PGStatement = PooledConnectionImpl.class$("org.postgresql.PGStatement")) : class$org$postgresql$PGStatement}, (InvocationHandler)new StatementHandler(this, st));
            }
            if (method.getName().equals("prepareCall")) {
                Statement st = (Statement)method.invoke((Object)this.con, args);
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = PooledConnectionImpl.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement, class$org$postgresql$PGStatement == null ? (class$org$postgresql$PGStatement = PooledConnectionImpl.class$("org.postgresql.PGStatement")) : class$org$postgresql$PGStatement}, (InvocationHandler)new StatementHandler(this, st));
            }
            if (method.getName().equals("prepareStatement")) {
                Statement st = (Statement)method.invoke((Object)this.con, args);
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PooledConnectionImpl.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, class$org$postgresql$PGStatement == null ? (class$org$postgresql$PGStatement = PooledConnectionImpl.class$("org.postgresql.PGStatement")) : class$org$postgresql$PGStatement}, (InvocationHandler)new StatementHandler(this, st));
            }
            return method.invoke((Object)this.con, args);
        }

        Connection getProxy() {
            return this.proxy;
        }

        void setProxy(Connection proxy) {
            this.proxy = proxy;
        }

        public void close() {
            if (this.con != null) {
                this.automatic = true;
            }
            this.con = null;
            this.proxy = null;
        }

        public boolean isClosed() {
            return this.con == null;
        }
    }
}

